/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialRequest;
import com.liferay.portlet.social.model.SocialRequestFeedEntry;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.model.impl.SocialRequestInterpreterImpl;
import com.liferay.portlet.social.service.base.SocialRequestInterpreterLocalServiceBaseImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SocialRequestInterpreterLocalServiceImpl
extends SocialRequestInterpreterLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(SocialRequestInterpreterLocalServiceImpl.class);
    private List<SocialRequestInterpreter> _requestInterpreters = new CopyOnWriteArrayList<SocialRequestInterpreter>();
    private ServiceRegistrationMap<SocialRequestInterpreter> _serviceRegistrations = new ServiceRegistrationMap();
    private ServiceTracker<SocialRequestInterpreter, SocialRequestInterpreter> _serviceTracker;

    public void addRequestInterpreter(SocialRequestInterpreter requestInterpreter) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        SocialRequestInterpreterImpl requestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
        properties.put("javax.portlet.name", requestInterpreterImpl.getPortletId());
        ServiceRegistration serviceRegistration = registry.registerService(SocialRequestInterpreter.class, (Object)requestInterpreter, properties);
        this._serviceRegistrations.put((Object)requestInterpreter, (Object)serviceRegistration);
    }

    @Override
    public void afterPropertiesSet() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=*)(objectClass=" + SocialRequestInterpreter.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new SocialRequestInterpreterServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void deleteRequestInterpreter(SocialRequestInterpreter requestInterpreter) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)requestInterpreter);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public SocialRequestFeedEntry interpret(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName((long)request.getClassNameId());
        for (int i = 0; i < this._requestInterpreters.size(); ++i) {
            SocialRequestFeedEntry requestFeedEntry;
            SocialRequestInterpreterImpl requestInterpreter = (SocialRequestInterpreterImpl)this._requestInterpreters.get(i);
            if (!this.matches(requestInterpreter, className, request) || (requestFeedEntry = requestInterpreter.interpret(request, themeDisplay)) == null) continue;
            requestFeedEntry.setPortletId(requestInterpreter.getPortletId());
            return requestFeedEntry;
        }
        return null;
    }

    public void processConfirmation(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName((long)request.getClassNameId());
        for (int i = 0; i < this._requestInterpreters.size(); ++i) {
            boolean value;
            SocialRequestInterpreterImpl requestInterpreter = (SocialRequestInterpreterImpl)this._requestInterpreters.get(i);
            if (!this.matches(requestInterpreter, className, request) || !(value = requestInterpreter.processConfirmation(request, themeDisplay))) continue;
            return;
        }
    }

    public void processRejection(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName((long)request.getClassNameId());
        for (int i = 0; i < this._requestInterpreters.size(); ++i) {
            boolean value;
            SocialRequestInterpreterImpl requestInterpreter = (SocialRequestInterpreterImpl)this._requestInterpreters.get(i);
            if (!this.matches(requestInterpreter, className, request) || !(value = requestInterpreter.processRejection(request, themeDisplay))) continue;
            return;
        }
    }

    protected String getSocialRequestPortletId(SocialRequest request) {
        try {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)request.getExtraData());
            return extraDataJSONObject.getString("portletId");
        }
        catch (JSONException jsone) {
            _log.error((Object)("Unable to create JSON object from " + request.getExtraData()));
            return "";
        }
    }

    protected boolean matches(SocialRequestInterpreterImpl requestInterpreter, String className, SocialRequest request) {
        if (!requestInterpreter.hasClassName(className)) {
            return false;
        }
        String requestPortletId = this.getSocialRequestPortletId(request);
        return Validator.isNull((String)requestPortletId) || requestPortletId.equals(requestInterpreter.getPortletId());
    }

    private class SocialRequestInterpreterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SocialRequestInterpreter, SocialRequestInterpreter> {
        private SocialRequestInterpreterServiceTrackerCustomizer() {
        }

        public SocialRequestInterpreter addingService(ServiceReference<SocialRequestInterpreter> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            SocialRequestInterpreter requestInterpreter = (SocialRequestInterpreter)registry.getService(serviceReference);
            String portletId = (String)serviceReference.getProperty("javax.portlet.name");
            if (!(requestInterpreter instanceof SocialRequestInterpreterImpl)) {
                requestInterpreter = new SocialRequestInterpreterImpl(portletId, requestInterpreter);
            }
            SocialRequestInterpreterLocalServiceImpl.this._requestInterpreters.add(requestInterpreter);
            return requestInterpreter;
        }

        public void modifiedService(ServiceReference<SocialRequestInterpreter> serviceReference, SocialRequestInterpreter requestInterpreter) {
        }

        public void removedService(ServiceReference<SocialRequestInterpreter> serviceReference, SocialRequestInterpreter requestInterpreter) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            SocialRequestInterpreterLocalServiceImpl.this._requestInterpreters.remove(requestInterpreter);
        }
    }
}

