/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.model.SocialActivitySetting;
import com.liferay.portlet.social.service.base.SocialActivitySettingServiceBaseImpl;
import com.liferay.portlet.social.service.permission.SocialActivityPermissionUtil;
import com.liferay.portlet.social.util.comparator.SocialActivityDefinitionNameComparator;
import java.util.Collections;
import java.util.List;

public class SocialActivitySettingServiceImpl
extends SocialActivitySettingServiceBaseImpl {
    public SocialActivityDefinition getActivityDefinition(long groupId, String className, int activityType) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.socialActivitySettingLocalService.getActivityDefinition(groupId, className, activityType);
    }

    public List<SocialActivityDefinition> getActivityDefinitions(long groupId, String className) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.socialActivitySettingLocalService.getActivityDefinitions(groupId, className);
    }

    public List<SocialActivitySetting> getActivitySettings(long groupId) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.socialActivitySettingLocalService.getActivitySettings(groupId);
    }

    public JSONArray getJSONActivityDefinitions(long groupId, String className) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List activityDefinitions = this.socialActivitySettingLocalService.getActivityDefinitions(groupId, className);
        Collections.sort(activityDefinitions, new SocialActivityDefinitionNameComparator(LocaleUtil.getMostRelevantLocale()));
        for (SocialActivityDefinition activityDefinition : activityDefinitions) {
            if (!activityDefinition.isCountersEnabled()) continue;
            JSONObject activityDefinitionJSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)activityDefinition));
            JSONArray activityCounterDefinitionsJSONArray = JSONFactoryUtil.createJSONArray();
            for (SocialActivityCounterDefinition activityCounterDefinition : activityDefinition.getActivityCounterDefinitions()) {
                JSONObject activityCounterDefinitionJSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)activityCounterDefinition));
                activityCounterDefinitionsJSONArray.put(activityCounterDefinitionJSONObject);
            }
            activityDefinitionJSONObject.put("counters", activityCounterDefinitionsJSONArray);
            jsonArray.put(activityDefinitionJSONObject);
        }
        return jsonArray;
    }

    public void updateActivitySetting(long groupId, String className, boolean enabled) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"CONFIGURATION");
        this.socialActivitySettingLocalService.updateActivitySetting(groupId, className, enabled);
    }

    public void updateActivitySetting(long groupId, String className, int activityType, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"CONFIGURATION");
        this.socialActivitySettingLocalService.updateActivitySetting(groupId, className, activityType, activityCounterDefinition);
    }

    public void updateActivitySettings(long groupId, String className, int activityType, List<SocialActivityCounterDefinition> activityCounterDefinitions) throws PortalException {
        SocialActivityPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"CONFIGURATION");
        this.socialActivitySettingLocalService.updateActivitySettings(groupId, className, activityType, activityCounterDefinitions);
    }
}

