/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserGroupRoleRoleChecker
extends RowChecker {
    private static Log _log = LogFactoryUtil.getLog(UserGroupRoleRoleChecker.class);
    private Group _group;
    private User _user;

    public UserGroupRoleRoleChecker(RenderResponse renderResponse, User user, Group group) {
        super((PortletResponse)renderResponse);
        this._user = user;
        this._group = group;
    }

    public boolean isChecked(Object obj) {
        Role role = (Role)obj;
        try {
            return UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isDisabled(Object obj) {
        Role role = (Role)obj;
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (this.isChecked(role) ? SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)permissionChecker, (long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId()) || SiteMembershipPolicyUtil.isRoleRequired((long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId()) : !SiteMembershipPolicyUtil.isRoleAllowed((long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId())) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return super.isDisabled(obj);
    }
}

