/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.action;

import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.GroupNameException;
import com.liferay.portal.GroupParentException;
import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PendingBackgroundTaskException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.RequiredGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.RemoteAuthException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeServiceUtil;
import com.liferay.portal.service.LayoutSetServiceUtil;
import com.liferay.portal.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.service.MembershipRequestServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditGroupAction
extends PortletAction {
    private static final int _LAYOUT_SET_VISIBILITY_PRIVATE = 1;

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                Object[] returnValue = this.updateGroup(actionRequest);
                Group group = (Group)returnValue[0];
                Layout layout = themeDisplay.getLayout();
                Group layoutGroup = layout.getGroup();
                if (cmd.equals("add") && layoutGroup.isControlPanel()) {
                    themeDisplay.setScopeGroupId(group.getGroupId());
                    PortletURL siteAdministrationURL = PortalUtil.getSiteAdministrationURL((PortletResponse)actionResponse, (ThemeDisplay)themeDisplay, (String)"165");
                    String controlPanelURL = HttpUtil.setParameter((String)themeDisplay.getURLControlPanel(), (String)"p_p_id", (String)"134");
                    controlPanelURL = HttpUtil.setParameter((String)controlPanelURL, (String)"controlPanelCategory", (String)themeDisplay.getControlPanelCategory());
                    siteAdministrationURL.setParameter("redirect", controlPanelURL);
                    redirect = siteAdministrationURL.toString();
                    this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                    MultiSessionMessages.add((PortletRequest)actionRequest, (String)"165requestProcessed");
                } else {
                    String oldFriendlyURL = (String)returnValue[1];
                    String oldStagingFriendlyURL = (String)returnValue[2];
                    long newRefererPlid = (Long)returnValue[3];
                    redirect = HttpUtil.setParameter((String)redirect, (String)"doAsGroupId", (long)group.getGroupId());
                    redirect = HttpUtil.setParameter((String)redirect, (String)"refererPlid", (long)newRefererPlid);
                    closeRedirect = this.updateCloseRedirect(closeRedirect, group, themeDisplay, oldFriendlyURL, oldStagingFriendlyURL);
                }
            } else if (cmd.equals("deactivate") || cmd.equals("restore")) {
                this.updateActive(actionRequest, cmd);
            } else if (cmd.equals("delete")) {
                this.deleteGroups(actionRequest);
            } else if (cmd.equals("reset_merge_fail_count_and_merge")) {
                this.resetMergeFailCountAndMerge(actionRequest);
            }
            this.sendRedirect(portletConfig, actionRequest, actionResponse, redirect, closeRedirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.sites_admin.error");
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException || e instanceof AuthException || e instanceof DuplicateGroupException || e instanceof GroupFriendlyURLException || e instanceof GroupNameException || e instanceof GroupParentException || e instanceof LayoutSetVirtualHostException || e instanceof LocaleException || e instanceof PendingBackgroundTaskException || e instanceof RemoteAuthException || e instanceof RemoteExportException || e instanceof RemoteOptionsException || e instanceof RequiredGroupException || e instanceof SystemException) {
                if (e instanceof RemoteAuthException) {
                    SessionErrors.add((PortletRequest)actionRequest, AuthException.class, (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                int stagingType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"stagingType");
                if (stagingType != 0) {
                    redirect = HttpUtil.setParameter((String)redirect, (String)(actionResponse.getNamespace() + "stagingType"), (int)stagingType);
                }
                this.sendRedirect(portletConfig, actionRequest, actionResponse, redirect, closeRedirect);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.sites_admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.sites_admin.edit_site"));
    }

    protected void deleteGroups(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] deleteGroupIds = null;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        deleteGroupIds = groupId > 0L ? new long[]{groupId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteGroupIds"), (long)0L);
        for (long deleteGroupId : deleteGroupIds) {
            GroupServiceUtil.deleteGroup((long)deleteGroupId);
            LiveUsers.deleteGroup(themeDisplay.getCompanyId(), deleteGroupId);
        }
    }

    protected long getRefererGroupId(ThemeDisplay themeDisplay) throws Exception {
        long refererGroupId = 0L;
        try {
            Layout refererLayout = LayoutLocalServiceUtil.getLayout((long)themeDisplay.getRefererPlid());
            refererGroupId = refererLayout.getGroupId();
        }
        catch (NoSuchLayoutException nsle) {
            // empty catch block
        }
        return refererGroupId;
    }

    protected List<Role> getRoles(PortletRequest portletRequest) throws Exception {
        long[] siteRolesRoleIds;
        ArrayList<Role> roles = new ArrayList<Role>();
        for (long siteRolesRoleId : siteRolesRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)"siteRolesRoleIds"), (long)0L)) {
            if (siteRolesRoleId == 0L) continue;
            Role role = RoleLocalServiceUtil.getRole((long)siteRolesRoleId);
            roles.add(role);
        }
        return roles;
    }

    protected List<Team> getTeams(PortletRequest portletRequest) throws Exception {
        long[] teamsTeamIds;
        ArrayList<Team> teams = new ArrayList<Team>();
        for (long teamsTeamId : teamsTeamIds = ArrayUtil.unique((long[])StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)"teamsTeamIds"), (long)0L))) {
            if (teamsTeamId == 0L) continue;
            Team team = TeamLocalServiceUtil.getTeam((long)teamsTeamId);
            teams.add(team);
        }
        return teams;
    }

    protected void resetMergeFailCountAndMerge(ActionRequest actionRequest) throws Exception {
        long layoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetPrototypeId");
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeServiceUtil.getLayoutSetPrototype((long)layoutSetPrototypeId);
        SitesUtil.setMergeFailCount((LayoutSetPrototype)layoutSetPrototype, (int)0);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayoutSet = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSet");
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayoutSet);
        SitesUtil.resetPrototype((LayoutSet)layoutSet);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
        layoutSetPrototype = LayoutSetPrototypeServiceUtil.getLayoutSetPrototype((long)layoutSetPrototypeId);
        if (SitesUtil.getMergeFailCount((LayoutSetPrototype)layoutSetPrototype) > 0) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"resetMergeFailCountAndMerge");
        }
    }

    protected void updateActive(ActionRequest actionRequest, String cmd) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (groupId == themeDisplay.getDoAsGroupId() || groupId == themeDisplay.getScopeGroupId() || groupId == this.getRefererGroupId(themeDisplay)) {
            throw new RequiredGroupException(String.valueOf(groupId), 3);
        }
        Group group = GroupServiceUtil.getGroup((long)groupId);
        boolean active = false;
        if (cmd.equals("restore")) {
            active = true;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        GroupServiceUtil.updateGroup((long)groupId, (long)group.getParentGroupId(), (String)group.getName(), (String)group.getDescription(), (int)group.getType(), (boolean)group.isManualMembership(), (int)group.getMembershipRestriction(), (String)group.getFriendlyURL(), (boolean)active, (ServiceContext)serviceContext);
    }

    protected String updateCloseRedirect(String closeRedirect, Group group, ThemeDisplay themeDisplay, String oldFriendlyURL, String oldStagingFriendlyURL) throws PortalException {
        if (Validator.isNull((String)closeRedirect) || group == null) {
            return closeRedirect;
        }
        String oldPath = null;
        String newPath = null;
        if (Validator.isNotNull((String)oldFriendlyURL)) {
            oldPath = oldFriendlyURL;
            newPath = group.getFriendlyURL();
            closeRedirect = closeRedirect.contains(oldPath) ? PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath) : PortalUtil.getGroupFriendlyURL((Group)group, (boolean)false, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNotNull((String)oldStagingFriendlyURL)) {
            Group stagingGroup = group.getStagingGroup();
            if (GroupLocalServiceUtil.fetchGroup((long)stagingGroup.getGroupId()) == null) {
                oldPath = oldStagingFriendlyURL;
                newPath = group.getFriendlyURL();
            } else {
                oldPath = oldStagingFriendlyURL;
                newPath = stagingGroup.getFriendlyURL();
            }
            closeRedirect = closeRedirect.contains(oldPath) ? PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath) : PortalUtil.getGroupFriendlyURL((Group)group, (boolean)false, (ThemeDisplay)themeDisplay);
        }
        return closeRedirect;
    }

    protected Object[] updateGroup(ActionRequest actionRequest) throws Exception {
        String[] analyticsTypes;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = PortalUtil.getUserId((PortletRequest)actionRequest);
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long parentGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentGroupSearchContainerPrimaryKeys", (long)0L);
        String name = null;
        String description = null;
        int type = 0;
        String friendlyURL = null;
        boolean active = false;
        boolean manualMembership = true;
        int membershipRestriction = 0;
        boolean actionRequestMembershipRestriction = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"membershipRestriction");
        if (actionRequestMembershipRestriction && parentGroupId != 0L) {
            membershipRestriction = 1;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        Group liveGroup = null;
        String oldFriendlyURL = null;
        String oldStagingFriendlyURL = null;
        if (liveGroupId <= 0L) {
            name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
            description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
            type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL");
            active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
            manualMembership = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"manualMembership");
            liveGroup = GroupServiceUtil.addGroup((long)parentGroupId, (long)0L, (String)name, (String)description, (int)type, (boolean)manualMembership, (int)membershipRestriction, (String)friendlyURL, (boolean)true, (boolean)active, (ServiceContext)serviceContext);
            LiveUsers.joinGroup(themeDisplay.getCompanyId(), liveGroup.getGroupId(), userId);
        } else {
            liveGroup = GroupLocalServiceUtil.getGroup((long)liveGroupId);
            oldFriendlyURL = liveGroup.getFriendlyURL();
            name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name", (String)liveGroup.getName());
            description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description", (String)liveGroup.getDescription());
            type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)liveGroup.getType());
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL", (String)liveGroup.getFriendlyURL());
            active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active", (boolean)liveGroup.getActive());
            manualMembership = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"manualMembership", (boolean)liveGroup.isManualMembership());
            liveGroup = GroupServiceUtil.updateGroup((long)liveGroupId, (long)parentGroupId, (String)name, (String)description, (int)type, (boolean)manualMembership, (int)membershipRestriction, (String)friendlyURL, (boolean)active, (ServiceContext)serviceContext);
            if (type == 1) {
                List membershipRequests = MembershipRequestLocalServiceUtil.search((long)liveGroupId, (int)0, (int)-1, (int)-1);
                for (MembershipRequest membershipRequest : membershipRequests) {
                    MembershipRequestServiceUtil.updateStatus((long)membershipRequest.getMembershipRequestId(), (String)themeDisplay.translate("your-membership-has-been-approved"), (int)1, (ServiceContext)serviceContext);
                    LiveUsers.joinGroup(themeDisplay.getCompanyId(), membershipRequest.getGroupId(), new long[]{membershipRequest.getUserId()});
                }
            }
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        String customJspServletContextName = ParamUtil.getString((PortletRequest)actionRequest, (String)"customJspServletContextName", (String)typeSettingsProperties.getProperty("customJspServletContextName"));
        typeSettingsProperties.setProperty("customJspServletContextName", customJspServletContextName);
        typeSettingsProperties.setProperty("defaultSiteRoleIds", ListUtil.toString(this.getRoles((PortletRequest)actionRequest), (Accessor)Role.ROLE_ID_ACCESSOR, (String)","));
        typeSettingsProperties.setProperty("defaultTeamIds", ListUtil.toString(this.getTeams((PortletRequest)actionRequest), (Accessor)Team.TEAM_ID_ACCESSOR, (String)","));
        for (String analyticsType : analyticsTypes = PrefsPropsUtil.getStringArray((long)themeDisplay.getCompanyId(), (String)"admin.analytics.types", (String)"\n")) {
            if (StringUtil.equalsIgnoreCase((String)analyticsType, (String)"google")) {
                String googleAnalyticsId = ParamUtil.getString((PortletRequest)actionRequest, (String)"googleAnalyticsId", (String)typeSettingsProperties.getProperty("googleAnalyticsId"));
                typeSettingsProperties.setProperty("googleAnalyticsId", googleAnalyticsId);
                continue;
            }
            String analyticsScript = ParamUtil.getString((PortletRequest)actionRequest, (String)("analytics_" + analyticsType), (String)typeSettingsProperties.getProperty(analyticsType));
            typeSettingsProperties.setProperty("analytics_" + analyticsType, analyticsScript);
        }
        String publicRobots = ParamUtil.getString((PortletRequest)actionRequest, (String)"publicRobots", (String)liveGroup.getTypeSettingsProperty("false-robots.txt"));
        String privateRobots = ParamUtil.getString((PortletRequest)actionRequest, (String)"privateRobots", (String)liveGroup.getTypeSettingsProperty("true-robots.txt"));
        typeSettingsProperties.setProperty("false-robots.txt", publicRobots);
        typeSettingsProperties.setProperty("true-robots.txt", privateRobots);
        boolean trashEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"trashEnabled", (boolean)GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("trashEnabled"), (boolean)true));
        typeSettingsProperties.setProperty("trashEnabled", String.valueOf(trashEnabled));
        int trashEntriesMaxAgeCompany = PrefsPropsUtil.getInteger((long)themeDisplay.getCompanyId(), (String)"trash.entries.max.age");
        double trashEntriesMaxAgeGroup = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"trashEntriesMaxAge");
        trashEntriesMaxAgeGroup = trashEntriesMaxAgeGroup > 0.0 ? (trashEntriesMaxAgeGroup *= 1440.0) : (double)GetterUtil.getInteger((String)typeSettingsProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAgeCompany);
        if (trashEntriesMaxAgeGroup != (double)trashEntriesMaxAgeCompany) {
            typeSettingsProperties.setProperty("trashEntriesMaxAge", String.valueOf(GetterUtil.getInteger((Object)trashEntriesMaxAgeGroup)));
        } else {
            typeSettingsProperties.remove((Object)"trashEntriesMaxAge");
        }
        int contentSharingWithChildrenEnabled = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"contentSharingWithChildrenEnabled", (int)GetterUtil.getInteger((String)typeSettingsProperties.getProperty("contentSharingWithChildrenEnabled"), (int)-1));
        typeSettingsProperties.setProperty("contentSharingWithChildrenEnabled", String.valueOf(contentSharingWithChildrenEnabled));
        UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        typeSettingsProperties.putAll((Map)formTypeSettingsProperties);
        LayoutSet publicLayoutSet = liveGroup.getPublicLayoutSet();
        String publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"publicVirtualHost", (String)publicLayoutSet.getVirtualHostname());
        LayoutSetServiceUtil.updateVirtualHost((long)liveGroup.getGroupId(), (boolean)false, (String)publicVirtualHost);
        LayoutSet privateLayoutSet = liveGroup.getPrivateLayoutSet();
        String privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"privateVirtualHost", (String)privateLayoutSet.getVirtualHostname());
        LayoutSetServiceUtil.updateVirtualHost((long)liveGroup.getGroupId(), (boolean)true, (String)privateVirtualHost);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            oldStagingFriendlyURL = stagingGroup.getFriendlyURL();
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingFriendlyURL", (String)stagingGroup.getFriendlyURL());
            GroupServiceUtil.updateFriendlyURL((long)stagingGroup.getGroupId(), (String)friendlyURL);
            LayoutSet stagingPublicLayoutSet = stagingGroup.getPublicLayoutSet();
            publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPublicVirtualHost", (String)stagingPublicLayoutSet.getVirtualHostname());
            LayoutSetServiceUtil.updateVirtualHost((long)stagingGroup.getGroupId(), (boolean)false, (String)publicVirtualHost);
            LayoutSet stagingPrivateLayoutSet = stagingGroup.getPrivateLayoutSet();
            privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPrivateVirtualHost", (String)stagingPrivateLayoutSet.getVirtualHostname());
            LayoutSetServiceUtil.updateVirtualHost((long)stagingGroup.getGroupId(), (boolean)true, (String)privateVirtualHost);
        }
        liveGroup = GroupServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled", (boolean)privateLayoutSet.isLayoutSetPrototypeLinkEnabled());
        boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled", (boolean)publicLayoutSet.isLayoutSetPrototypeLinkEnabled());
        if (privateLayoutSetPrototypeId == 0L && publicLayoutSetPrototypeId == 0L && !privateLayoutSetPrototypeLinkEnabled && !publicLayoutSetPrototypeLinkEnabled) {
            long layoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetPrototypeId");
            int layoutSetVisibility = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"layoutSetVisibility");
            boolean layoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"layoutSetPrototypeLinkEnabled", (layoutSetPrototypeId > 0L ? 1 : 0) != 0);
            if (layoutSetVisibility == 1) {
                privateLayoutSetPrototypeId = layoutSetPrototypeId;
                privateLayoutSetPrototypeLinkEnabled = layoutSetPrototypeLinkEnabled;
            } else {
                publicLayoutSetPrototypeId = layoutSetPrototypeId;
                publicLayoutSetPrototypeLinkEnabled = layoutSetPrototypeLinkEnabled;
            }
        }
        if (!liveGroup.isStaged() || liveGroup.isStagedRemotely()) {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)liveGroup, (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        } else {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)liveGroup.getStagingGroup(), (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        }
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        long refererPlid = GetterUtil.getLong((String)HttpUtil.getParameter((String)redirect, (String)"refererPlid", (boolean)false));
        if (!privateLayoutSet.isLayoutSetPrototypeLinkActive() && !publicLayoutSet.isLayoutSetPrototypeLinkActive()) {
            if (refererPlid > 0L && liveGroup.hasStagingGroup() && themeDisplay.getScopeGroupId() != liveGroup.getGroupId()) {
                Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)liveGroup.getGroupId(), (boolean)false, (long)0L);
                if (firstLayout == null) {
                    firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)liveGroup.getGroupId(), (boolean)true, (long)0L);
                }
                refererPlid = firstLayout != null ? firstLayout.getPlid() : 0L;
            }
            StagingUtil.updateStaging((PortletRequest)actionRequest, (Group)liveGroup);
        }
        return new Object[]{liveGroup, oldFriendlyURL, oldStagingFriendlyURL, refererPlid};
    }
}

