/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.shopping.BillingCityException;
import com.liferay.portlet.shopping.BillingCountryException;
import com.liferay.portlet.shopping.BillingEmailAddressException;
import com.liferay.portlet.shopping.BillingFirstNameException;
import com.liferay.portlet.shopping.BillingLastNameException;
import com.liferay.portlet.shopping.BillingPhoneException;
import com.liferay.portlet.shopping.BillingStateException;
import com.liferay.portlet.shopping.BillingStreetException;
import com.liferay.portlet.shopping.BillingZipException;
import com.liferay.portlet.shopping.CCExpirationException;
import com.liferay.portlet.shopping.CCNameException;
import com.liferay.portlet.shopping.CCNumberException;
import com.liferay.portlet.shopping.CCTypeException;
import com.liferay.portlet.shopping.CartMinOrderException;
import com.liferay.portlet.shopping.ShippingCityException;
import com.liferay.portlet.shopping.ShippingCountryException;
import com.liferay.portlet.shopping.ShippingEmailAddressException;
import com.liferay.portlet.shopping.ShippingFirstNameException;
import com.liferay.portlet.shopping.ShippingLastNameException;
import com.liferay.portlet.shopping.ShippingPhoneException;
import com.liferay.portlet.shopping.ShippingStateException;
import com.liferay.portlet.shopping.ShippingStreetException;
import com.liferay.portlet.shopping.ShippingZipException;
import com.liferay.portlet.shopping.ShoppingSettings;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingCartItem;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemField;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.model.ShoppingOrderItem;
import com.liferay.portlet.shopping.model.impl.ShoppingCartItemImpl;
import com.liferay.portlet.shopping.service.base.ShoppingOrderLocalServiceBaseImpl;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import com.liferay.portlet.shopping.util.comparator.OrderDateComparator;
import com.liferay.util.CreditCard;
import com.liferay.util.PwdGenerator;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ShoppingOrderLocalServiceImpl
extends ShoppingOrderLocalServiceBaseImpl {
    public ShoppingOrder addLatestOrder(long userId, long groupId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        String number = this.getNumber();
        ShoppingOrder order = null;
        long orderId = this.counterLocalService.increment();
        List pastOrders = this.shoppingOrderPersistence.findByG_U_PPPS(groupId, userId, "LIFERAY_STATUS_CHECKOUT", 0, 1);
        if (!pastOrders.isEmpty()) {
            ShoppingOrder pastOrder = (ShoppingOrder)pastOrders.get(0);
            order = this.shoppingOrderPersistence.create(orderId);
            order.setBillingCompany(pastOrder.getBillingCompany());
            order.setBillingStreet(pastOrder.getBillingStreet());
            order.setBillingCity(pastOrder.getBillingCity());
            order.setBillingState(pastOrder.getBillingState());
            order.setBillingZip(pastOrder.getBillingZip());
            order.setBillingCountry(pastOrder.getBillingCountry());
            order.setBillingPhone(pastOrder.getBillingPhone());
            order.setShipToBilling(pastOrder.isShipToBilling());
            order.setShippingCompany(pastOrder.getShippingCompany());
            order.setShippingStreet(pastOrder.getShippingStreet());
            order.setShippingCity(pastOrder.getShippingCity());
            order.setShippingState(pastOrder.getShippingState());
            order.setShippingZip(pastOrder.getShippingZip());
            order.setShippingCountry(pastOrder.getShippingCountry());
            order.setShippingPhone(pastOrder.getShippingPhone());
        } else {
            order = this.shoppingOrderPersistence.create(orderId);
        }
        order.setGroupId(groupId);
        order.setCompanyId(user.getCompanyId());
        order.setUserId(user.getUserId());
        order.setUserName(user.getFullName());
        order.setCreateDate(now);
        order.setModifiedDate(now);
        order.setNumber(number);
        order.setBillingFirstName(user.getFirstName());
        order.setBillingLastName(user.getLastName());
        order.setBillingEmailAddress(user.getEmailAddress());
        order.setShippingFirstName(user.getFirstName());
        order.setShippingLastName(user.getLastName());
        order.setShippingEmailAddress(user.getEmailAddress());
        order.setCcName(user.getFullName());
        order.setPpPaymentStatus("LIFERAY_STATUS_LATEST");
        order.setSendOrderEmail(true);
        order.setSendShippingEmail(true);
        this.shoppingOrderPersistence.update((BaseModel)order);
        if (PropsValues.SHOPPING_ORDER_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, order.getUserName(), groupId, ShoppingOrder.class.getName(), orderId, 1);
        }
        return order;
    }

    public void completeOrder(String number, String ppTxnId, String ppPaymentStatus, double ppPaymentGross, String ppReceiverEmail, String ppPayerEmail, boolean updateInventory, ServiceContext serviceContext) throws PortalException {
        ShoppingOrder order = this.shoppingOrderPersistence.findByNumber(number);
        order.setModifiedDate(new Date());
        order.setPpTxnId(ppTxnId);
        order.setPpPaymentStatus(ppPaymentStatus);
        order.setPpPaymentGross(ppPaymentGross);
        order.setPpReceiverEmail(ppReceiverEmail);
        order.setPpPayerEmail(ppPayerEmail);
        this.shoppingOrderPersistence.update((BaseModel)order);
        if (updateInventory && ppPaymentStatus.equals("Completed")) {
            List orderItems = this.shoppingOrderItemLocalService.getOrderItems(order.getOrderId());
            for (ShoppingOrderItem orderItem : orderItems) {
                ShoppingItem item = this.shoppingItemLocalService.getItem(ShoppingUtil.getItemId(orderItem.getItemId()));
                if (item.isInfiniteStock()) continue;
                if (!item.isFields()) {
                    int quantity = item.getStockQuantity() - orderItem.getQuantity();
                    item.setStockQuantity(quantity);
                } else {
                    List itemFields = this.shoppingItemFieldLocalService.getItemFields(item.getItemId());
                    ShoppingItemField[] itemFieldsArray = itemFields.toArray(new ShoppingItemField[itemFields.size()]);
                    String[] fieldsArray = ShoppingCartItemImpl.getFieldsArray(ShoppingUtil.getItemFields(orderItem.getItemId()));
                    int rowPos = ShoppingUtil.getFieldsQuantitiesPos(item, itemFieldsArray, fieldsArray);
                    String[] fieldsQuantities = item.getFieldsQuantitiesArray();
                    try {
                        int quantity = GetterUtil.getInteger((String)fieldsQuantities[rowPos]) - orderItem.getQuantity();
                        fieldsQuantities[rowPos] = String.valueOf(quantity);
                        item.setFieldsQuantitiesArray(fieldsQuantities);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.shoppingItemPersistence.update((BaseModel)item);
            }
        }
        this.sendEmail(order, "confirmation", serviceContext);
    }

    public void deleteOrder(long orderId) throws PortalException {
        ShoppingOrder order = this.shoppingOrderPersistence.findByPrimaryKey(orderId);
        this.deleteOrder(order);
    }

    public void deleteOrder(ShoppingOrder order) throws PortalException {
        this.shoppingOrderPersistence.remove((BaseModel)order);
        this.subscriptionLocalService.deleteSubscriptions(order.getCompanyId(), ShoppingOrder.class.getName(), order.getOrderId());
        this.shoppingOrderItemPersistence.removeByOrderId(order.getOrderId());
        this.mbMessageLocalService.deleteDiscussionMessages(ShoppingOrder.class.getName(), order.getOrderId());
    }

    public void deleteOrders(long groupId) throws PortalException {
        List orders = this.shoppingOrderPersistence.findByGroupId(groupId);
        for (ShoppingOrder order : orders) {
            this.deleteOrder(order);
        }
    }

    public ShoppingOrder getLatestOrder(long userId, long groupId) throws PortalException {
        return this.shoppingOrderPersistence.findByG_U_PPPS_First(groupId, userId, "LIFERAY_STATUS_LATEST", null);
    }

    public ShoppingOrder getOrder(long orderId) throws PortalException {
        return this.shoppingOrderPersistence.findByPrimaryKey(orderId);
    }

    public ShoppingOrder getOrder(String number) throws PortalException {
        return this.shoppingOrderPersistence.findByNumber(number);
    }

    public ShoppingOrder getPayPalTxnIdOrder(String ppTxnId) throws PortalException {
        return this.shoppingOrderPersistence.findByPPTxnId(ppTxnId);
    }

    public ShoppingOrder saveLatestOrder(ShoppingCart cart) throws PortalException {
        Map items = cart.getItems();
        Date now = new Date();
        ShoppingSettings shoppingSettings = ShoppingSettings.getInstance(cart.getGroupId());
        if (!ShoppingUtil.meetsMinOrder(shoppingSettings, items)) {
            throw new CartMinOrderException();
        }
        ShoppingOrder order = this.getLatestOrder(cart.getUserId(), cart.getGroupId());
        order.setCreateDate(now);
        order.setModifiedDate(now);
        order.setPpPaymentStatus("LIFERAY_STATUS_CHECKOUT");
        this.shoppingOrderPersistence.update((BaseModel)order);
        boolean requiresShipping = false;
        for (Map.Entry entry : items.entrySet()) {
            ShoppingCartItem cartItem = (ShoppingCartItem)entry.getKey();
            Integer count = (Integer)entry.getValue();
            ShoppingItem item = cartItem.getItem();
            if (item.isRequiresShipping()) {
                requiresShipping = true;
            }
            long orderItemId = this.counterLocalService.increment();
            ShoppingOrderItem orderItem = this.shoppingOrderItemPersistence.create(orderItemId);
            orderItem.setOrderId(order.getOrderId());
            orderItem.setItemId(cartItem.getCartItemId());
            orderItem.setSku(item.getSku());
            orderItem.setName(item.getName());
            orderItem.setDescription(item.getDescription());
            orderItem.setProperties(item.getProperties());
            orderItem.setPrice(ShoppingUtil.calculateActualPrice(item, count) / (double)count.intValue());
            orderItem.setQuantity(count.intValue());
            this.shoppingOrderItemPersistence.update((BaseModel)orderItem);
        }
        order.setModifiedDate(new Date());
        order.setTax(ShoppingUtil.calculateTax(items, order.getBillingState()));
        order.setShipping(ShoppingUtil.calculateAlternativeShipping(items, cart.getAltShipping()));
        order.setAltShipping(shoppingSettings.getAlternativeShippingName(cart.getAltShipping()));
        order.setRequiresShipping(requiresShipping);
        order.setInsure(cart.isInsure());
        order.setInsurance(ShoppingUtil.calculateInsurance(items));
        order.setCouponCodes(cart.getCouponCodes());
        order.setCouponDiscount(ShoppingUtil.calculateCouponDiscount(items, order.getBillingState(), cart.getCoupon()));
        order.setSendOrderEmail(true);
        order.setSendShippingEmail(true);
        this.shoppingOrderPersistence.update((BaseModel)order);
        return order;
    }

    public List<ShoppingOrder> search(long groupId, long companyId, long userId, String number, String billingFirstName, String billingLastName, String billingEmailAddress, String shippingFirstName, String shippingLastName, String shippingEmailAddress, String ppPaymentStatus, boolean andOperator, int start, int end) {
        OrderDateComparator obc = new OrderDateComparator(false);
        return this.shoppingOrderFinder.findByG_C_U_N_PPPS(groupId, companyId, userId, number, billingFirstName, billingLastName, billingEmailAddress, shippingFirstName, shippingLastName, shippingEmailAddress, ppPaymentStatus, andOperator, start, end, (OrderByComparator)obc);
    }

    public int searchCount(long groupId, long companyId, long userId, String number, String billingFirstName, String billingLastName, String billingEmailAddress, String shippingFirstName, String shippingLastName, String shippingEmailAddress, String ppPaymentStatus, boolean andOperator) {
        return this.shoppingOrderFinder.countByG_C_U_N_PPPS(groupId, companyId, userId, number, billingFirstName, billingLastName, billingEmailAddress, shippingFirstName, shippingLastName, shippingEmailAddress, ppPaymentStatus, andOperator);
    }

    public void sendEmail(long orderId, String emailType, ServiceContext serviceContext) throws PortalException {
        ShoppingOrder order = this.shoppingOrderPersistence.findByPrimaryKey(orderId);
        this.sendEmail(order, emailType, serviceContext);
    }

    public void sendEmail(ShoppingOrder order, String emailType, ServiceContext serviceContext) throws PortalException {
        ShoppingSettings shoppingSettings = ShoppingSettings.getInstance(order.getGroupId());
        if (!(emailType.equals("confirmation") && shoppingSettings.isEmailOrderConfirmationEnabled() || emailType.equals("shipping") && shoppingSettings.isEmailOrderShippingEnabled())) {
            return;
        }
        this.notifyUser(order, emailType, shoppingSettings, serviceContext);
        if (emailType.equals("confirmation") && order.isSendOrderEmail()) {
            order.setSendOrderEmail(false);
            this.shoppingOrderPersistence.update((BaseModel)order);
        } else if (emailType.equals("shipping") && order.isSendShippingEmail()) {
            order.setSendShippingEmail(false);
            this.shoppingOrderPersistence.update((BaseModel)order);
        }
    }

    public ShoppingOrder updateLatestOrder(long userId, long groupId, String billingFirstName, String billingLastName, String billingEmailAddress, String billingCompany, String billingStreet, String billingCity, String billingState, String billingZip, String billingCountry, String billingPhone, boolean shipToBilling, String shippingFirstName, String shippingLastName, String shippingEmailAddress, String shippingCompany, String shippingStreet, String shippingCity, String shippingState, String shippingZip, String shippingCountry, String shippingPhone, String ccName, String ccType, String ccNumber, int ccExpMonth, int ccExpYear, String ccVerNumber, String comments) throws PortalException {
        ShoppingOrder order = this.getLatestOrder(userId, groupId);
        return this.updateOrder(order.getOrderId(), billingFirstName, billingLastName, billingEmailAddress, billingCompany, billingStreet, billingCity, billingState, billingZip, billingCountry, billingPhone, shipToBilling, shippingFirstName, shippingLastName, shippingEmailAddress, shippingCompany, shippingStreet, shippingCity, shippingState, shippingZip, shippingCountry, shippingPhone, ccName, ccType, ccNumber, ccExpMonth, ccExpYear, ccVerNumber, comments);
    }

    public ShoppingOrder updateOrder(long orderId, String ppTxnId, String ppPaymentStatus, double ppPaymentGross, String ppReceiverEmail, String ppPayerEmail) throws PortalException {
        ShoppingOrder order = this.shoppingOrderPersistence.findByPrimaryKey(orderId);
        order.setModifiedDate(new Date());
        order.setPpTxnId(ppTxnId);
        order.setPpPaymentStatus(ppPaymentStatus);
        order.setPpPaymentGross(ppPaymentGross);
        order.setPpReceiverEmail(ppReceiverEmail);
        order.setPpPayerEmail(ppPayerEmail);
        this.shoppingOrderPersistence.update((BaseModel)order);
        return order;
    }

    public ShoppingOrder updateOrder(long orderId, String billingFirstName, String billingLastName, String billingEmailAddress, String billingCompany, String billingStreet, String billingCity, String billingState, String billingZip, String billingCountry, String billingPhone, boolean shipToBilling, String shippingFirstName, String shippingLastName, String shippingEmailAddress, String shippingCompany, String shippingStreet, String shippingCity, String shippingState, String shippingZip, String shippingCountry, String shippingPhone, String ccName, String ccType, String ccNumber, int ccExpMonth, int ccExpYear, String ccVerNumber, String comments) throws PortalException {
        ShoppingOrder order = this.shoppingOrderPersistence.findByPrimaryKey(orderId);
        ShoppingSettings shoppingSettings = ShoppingSettings.getInstance(order.getGroupId());
        this.validate(shoppingSettings, billingFirstName, billingLastName, billingEmailAddress, billingStreet, billingCity, billingState, billingZip, billingCountry, billingPhone, shipToBilling, shippingFirstName, shippingLastName, shippingEmailAddress, shippingStreet, shippingCity, shippingState, shippingZip, shippingCountry, shippingPhone, ccName, ccType, ccNumber, ccExpMonth, ccExpYear, ccVerNumber);
        order.setModifiedDate(new Date());
        order.setBillingFirstName(billingFirstName);
        order.setBillingLastName(billingLastName);
        order.setBillingEmailAddress(billingEmailAddress);
        order.setBillingCompany(billingCompany);
        order.setBillingStreet(billingStreet);
        order.setBillingCity(billingCity);
        order.setBillingState(billingState);
        order.setBillingZip(billingZip);
        order.setBillingCountry(billingCountry);
        order.setBillingPhone(billingPhone);
        order.setShipToBilling(shipToBilling);
        if (shipToBilling) {
            order.setShippingFirstName(billingFirstName);
            order.setShippingLastName(billingLastName);
            order.setShippingEmailAddress(billingEmailAddress);
            order.setShippingCompany(billingCompany);
            order.setShippingStreet(billingStreet);
            order.setShippingCity(billingCity);
            order.setShippingState(billingState);
            order.setShippingZip(billingZip);
            order.setShippingCountry(billingCountry);
            order.setShippingPhone(billingPhone);
        } else {
            order.setShippingFirstName(shippingFirstName);
            order.setShippingLastName(shippingLastName);
            order.setShippingEmailAddress(shippingEmailAddress);
            order.setShippingCompany(shippingCompany);
            order.setShippingStreet(shippingStreet);
            order.setShippingCity(shippingCity);
            order.setShippingState(shippingState);
            order.setShippingZip(shippingZip);
            order.setShippingCountry(shippingCountry);
            order.setShippingPhone(shippingPhone);
        }
        order.setCcName(ccName);
        order.setCcType(ccType);
        order.setCcNumber(ccNumber);
        order.setCcExpMonth(ccExpMonth);
        order.setCcExpYear(ccExpYear);
        order.setCcVerNumber(ccVerNumber);
        order.setComments(comments);
        this.shoppingOrderPersistence.update((BaseModel)order);
        return order;
    }

    protected String getNumber() {
        String number = PwdGenerator.getPassword((int)12, (String[])new String[]{"0123456789", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"});
        ShoppingOrder order = this.shoppingOrderPersistence.fetchByNumber(number);
        if (order != null) {
            return order.getNumber();
        }
        return number;
    }

    protected void notifyUser(ShoppingOrder order, String emailType, ShoppingSettings shoppingSettings, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(order.getUserId());
        Currency currency = Currency.getInstance(shoppingSettings.getCurrencyId());
        String billingAddress = order.getBillingFirstName() + " " + order.getBillingLastName() + "<br>" + order.getBillingEmailAddress() + "<br>" + order.getBillingStreet() + "<br>" + order.getBillingCity() + "<br>" + order.getBillingState() + "<br>" + order.getBillingZip() + "<br>" + order.getBillingCountry() + "<br>" + order.getBillingPhone() + "<br>";
        String shippingAddress = order.getShippingFirstName() + " " + order.getShippingLastName() + "<br>" + order.getShippingEmailAddress() + "<br>" + order.getShippingStreet() + "<br>" + order.getShippingCity() + "<br>" + order.getShippingState() + "<br>" + order.getShippingZip() + "<br>" + order.getShippingCountry() + "<br>" + order.getShippingPhone() + "<br>";
        double total = ShoppingUtil.calculateTotal(order);
        String fromName = shoppingSettings.getEmailFromName();
        String fromAddress = shoppingSettings.getEmailFromAddress();
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (emailType.equals("confirmation")) {
            subjectLocalizedValuesMap = shoppingSettings.getEmailOrderConfirmationSubject();
            bodyLocalizedValuesMap = shoppingSettings.getEmailOrderConfirmationBody();
        } else if (emailType.equals("shipping")) {
            subjectLocalizedValuesMap = shoppingSettings.getEmailOrderShippingSubject();
            bodyLocalizedValuesMap = shoppingSettings.getEmailOrderShippingBody();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(order.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ORDER_BILLING_ADDRESS$]", billingAddress, "[$ORDER_CURRENCY$]", currency.getSymbol(), "[$ORDER_NUMBER$]", order.getNumber(), "[$ORDER_SHIPPING_ADDRESS$]", shippingAddress, "[$ORDER_TOTAL$]", total});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap((Map)bodyLocalizedValuesMap);
        subscriptionSender.setLocalizedSubjectMap((Map)subjectLocalizedValuesMap);
        subscriptionSender.setMailId("shopping_order", new Object[]{order.getOrderId()});
        subscriptionSender.setPortletId("34");
        subscriptionSender.setScopeGroupId(order.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(order.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void validate(ShoppingSettings shoppingSettings, String billingFirstName, String billingLastName, String billingEmailAddress, String billingStreet, String billingCity, String billingState, String billingZip, String billingCountry, String billingPhone, boolean shipToBilling, String shippingFirstName, String shippingLastName, String shippingEmailAddress, String shippingStreet, String shippingCity, String shippingState, String shippingZip, String shippingCountry, String shippingPhone, String ccName, String ccType, String ccNumber, int ccExpMonth, int ccExpYear, String ccVerNumber) throws PortalException {
        if (Validator.isNull((String)billingFirstName)) {
            throw new BillingFirstNameException();
        }
        if (Validator.isNull((String)billingLastName)) {
            throw new BillingLastNameException();
        }
        if (!Validator.isEmailAddress((String)billingEmailAddress)) {
            throw new BillingEmailAddressException();
        }
        if (Validator.isNull((String)billingStreet)) {
            throw new BillingStreetException();
        }
        if (Validator.isNull((String)billingCity)) {
            throw new BillingCityException();
        }
        if (Validator.isNull((String)billingState)) {
            throw new BillingStateException();
        }
        if (Validator.isNull((String)billingZip)) {
            throw new BillingZipException();
        }
        if (Validator.isNull((String)billingCountry)) {
            throw new BillingCountryException();
        }
        if (Validator.isNull((String)billingPhone)) {
            throw new BillingPhoneException();
        }
        if (!shipToBilling) {
            if (Validator.isNull((String)shippingFirstName)) {
                throw new ShippingFirstNameException();
            }
            if (Validator.isNull((String)shippingLastName)) {
                throw new ShippingLastNameException();
            }
            if (!Validator.isEmailAddress((String)shippingEmailAddress)) {
                throw new ShippingEmailAddressException();
            }
            if (Validator.isNull((String)shippingStreet)) {
                throw new ShippingStreetException();
            }
            if (Validator.isNull((String)shippingCity)) {
                throw new ShippingCityException();
            }
            if (Validator.isNull((String)shippingState)) {
                throw new ShippingStateException();
            }
            if (Validator.isNull((String)shippingZip)) {
                throw new ShippingZipException();
            }
            if (Validator.isNull((String)shippingCountry)) {
                throw new ShippingCountryException();
            }
            if (Validator.isNull((String)shippingPhone)) {
                throw new ShippingPhoneException();
            }
        }
        if (!shoppingSettings.usePayPal() && shoppingSettings.getCcTypes().length > 0) {
            if (Validator.isNull((String)ccName)) {
                throw new CCNameException();
            }
            if (Validator.isNull((String)ccType)) {
                throw new CCTypeException();
            }
            if (!CreditCard.isValidNumber((String)ccNumber, (String)ccType)) {
                throw new CCNumberException();
            }
            if (!CreditCard.isValidExpirationDate((int)ccExpMonth, (int)ccExpYear)) {
                throw new CCExpirationException();
            }
        }
    }
}

