/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemSoap;
import com.liferay.portlet.shopping.service.ShoppingItemServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

@ProviderType
public class ShoppingItemServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(ShoppingItemServiceSoap.class);

    public static void deleteItem(long itemId) throws RemoteException {
        try {
            ShoppingItemServiceUtil.deleteItem((long)itemId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCategoriesItemsCount(long groupId, Long[] categoryIds) throws RemoteException {
        try {
            int returnValue = ShoppingItemServiceUtil.getCategoriesItemsCount((long)groupId, (List)ListUtil.toList((Object[])categoryIds));
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingItemSoap getItem(long itemId) throws RemoteException {
        try {
            ShoppingItem returnValue = ShoppingItemServiceUtil.getItem((long)itemId);
            return ShoppingItemSoap.toSoapModel((ShoppingItem)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingItemSoap[] getItems(long groupId, long categoryId) throws RemoteException {
        try {
            List returnValue = ShoppingItemServiceUtil.getItems((long)groupId, (long)categoryId);
            return ShoppingItemSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingItemSoap[] getItems(long groupId, long categoryId, int start, int end, OrderByComparator<ShoppingItem> obc) throws RemoteException {
        try {
            List returnValue = ShoppingItemServiceUtil.getItems((long)groupId, (long)categoryId, (int)start, (int)end, obc);
            return ShoppingItemSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getItemsCount(long groupId, long categoryId) throws RemoteException {
        try {
            int returnValue = ShoppingItemServiceUtil.getItemsCount((long)groupId, (long)categoryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ShoppingItemSoap[] getItemsPrevAndNext(long itemId, OrderByComparator<ShoppingItem> obc) throws RemoteException {
        try {
            ShoppingItem[] returnValue = ShoppingItemServiceUtil.getItemsPrevAndNext((long)itemId, obc);
            return ShoppingItemSoap.toSoapModels((ShoppingItem[])returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

