/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.shopping.NoSuchOrderException;
import com.liferay.portlet.shopping.action.ActionUtil;
import com.liferay.portlet.shopping.service.ShoppingOrderServiceUtil;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditOrderAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateOrder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteOrders(actionRequest);
            } else if (cmd.equals("sendEmail")) {
                this.sendEmail(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getOrder((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchOrderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.shopping.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.shopping.edit_order"));
    }

    protected void deleteOrders(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] deleteOrderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteOrderIds"), (long)0L);
        for (int i = 0; i < deleteOrderIds.length; ++i) {
            ShoppingOrderServiceUtil.deleteOrder((long)themeDisplay.getScopeGroupId(), (long)deleteOrderIds[i]);
        }
    }

    protected void sendEmail(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long orderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"orderId");
        String emailType = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        ShoppingOrderServiceUtil.sendEmail((long)themeDisplay.getScopeGroupId(), (long)orderId, (String)emailType, (ServiceContext)serviceContext);
    }

    protected void updateOrder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String number = ParamUtil.getString((PortletRequest)actionRequest, (String)"number");
        String ppTxnId = ParamUtil.getString((PortletRequest)actionRequest, (String)"ppTxnId");
        String ppPaymentStatus = ShoppingUtil.getPpPaymentStatus(ParamUtil.getString((PortletRequest)actionRequest, (String)"ppPaymentStatus"));
        double ppPaymentGross = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"ppPaymentGross");
        String ppReceiverEmail = ParamUtil.getString((PortletRequest)actionRequest, (String)"ppReceiverEmail");
        String ppPayerEmail = ParamUtil.getString((PortletRequest)actionRequest, (String)"ppPayerEmail");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        ShoppingOrderServiceUtil.completeOrder((long)themeDisplay.getScopeGroupId(), (String)number, (String)ppTxnId, (String)ppPaymentStatus, (double)ppPaymentGross, (String)ppReceiverEmail, (String)ppPayerEmail, (ServiceContext)serviceContext);
    }
}

