/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.shopping.DuplicateItemFieldNameException;
import com.liferay.portlet.shopping.DuplicateItemSKUException;
import com.liferay.portlet.shopping.ItemLargeImageNameException;
import com.liferay.portlet.shopping.ItemLargeImageSizeException;
import com.liferay.portlet.shopping.ItemMediumImageNameException;
import com.liferay.portlet.shopping.ItemMediumImageSizeException;
import com.liferay.portlet.shopping.ItemNameException;
import com.liferay.portlet.shopping.ItemSKUException;
import com.liferay.portlet.shopping.ItemSmallImageNameException;
import com.liferay.portlet.shopping.ItemSmallImageSizeException;
import com.liferay.portlet.shopping.NoSuchCategoryException;
import com.liferay.portlet.shopping.NoSuchItemException;
import com.liferay.portlet.shopping.action.ActionUtil;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemField;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.service.ShoppingItemServiceUtil;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFieldUtil;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPriceUtil;
import java.io.File;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditItemAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateItem(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteItem(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchCategoryException || e instanceof NoSuchItemException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
            }
            if (e instanceof DuplicateItemFieldNameException || e instanceof DuplicateItemSKUException || e instanceof ItemLargeImageNameException || e instanceof ItemLargeImageSizeException || e instanceof ItemMediumImageNameException || e instanceof ItemMediumImageSizeException || e instanceof ItemNameException || e instanceof ItemSKUException || e instanceof ItemSmallImageNameException || e instanceof ItemSmallImageSizeException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getItem((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.shopping.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.shopping.edit_item"));
    }

    protected void deleteItem(ActionRequest actionRequest) throws Exception {
        long itemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"itemId");
        ShoppingItemServiceUtil.deleteItem((long)itemId);
    }

    protected void updateItem(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long itemId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"itemId");
        long groupId = themeDisplay.getScopeGroupId();
        long categoryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"categoryId");
        String sku = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"sku");
        String name = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"name");
        String description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"description");
        String properties = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"properties");
        int fieldsCount = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"fieldsCount", (int)1);
        ArrayList<ShoppingItemField> itemFields = new ArrayList<ShoppingItemField>();
        for (int i = 0; i < fieldsCount; ++i) {
            String fieldName = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("fieldName" + i));
            String fieldValues = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("fieldValues" + i));
            String fieldDescription = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("fieldDescription" + i));
            ShoppingItemField itemField = ShoppingItemFieldUtil.create((long)0L);
            itemField.setName(fieldName);
            itemField.setValues(fieldValues);
            itemField.setDescription(fieldDescription);
            itemFields.add(itemField);
        }
        String fieldsQuantities = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"fieldsQuantities");
        int pricesCount = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"pricesCount", (int)1);
        ArrayList<ShoppingItemPrice> itemPrices = new ArrayList<ShoppingItemPrice>();
        for (int i = 0; i < pricesCount; ++i) {
            int minQuantity = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)("minQuantity" + i));
            int maxQuantity = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)("maxQuantity" + i));
            double price = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)("price" + i));
            double discount = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)("discount" + i)) / 100.0;
            boolean taxable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)("taxable" + i));
            double shipping = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)("shipping" + i));
            boolean useShippingFormula = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)("useShippingFormula" + i));
            boolean active = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)("active" + i));
            int defaultPrice = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"defaultPrice");
            int status = 1;
            if (defaultPrice != i && active) {
                status = 2;
            } else if (defaultPrice != i && !active) {
                status = 0;
            }
            ShoppingItemPrice itemPrice = ShoppingItemPriceUtil.create((long)0L);
            itemPrice.setMinQuantity(minQuantity);
            itemPrice.setMaxQuantity(maxQuantity);
            itemPrice.setPrice(price);
            itemPrice.setDiscount(discount);
            itemPrice.setTaxable(taxable);
            itemPrice.setShipping(shipping);
            itemPrice.setUseShippingFormula(useShippingFormula);
            itemPrice.setStatus(status);
            itemPrices.add(itemPrice);
        }
        boolean requiresShipping = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"requiresShipping");
        int stockQuantity = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"stockQuantity");
        if (ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"infiniteStock")) {
            stockQuantity = -1;
        }
        boolean featured = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"featured");
        Boolean sale = null;
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallFile = uploadPortletRequest.getFile("smallFile");
        boolean mediumImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"mediumImage");
        String mediumImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"mediumImageURL");
        File mediumFile = uploadPortletRequest.getFile("mediumFile");
        boolean largeImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"largeImage");
        String largeImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"largeImageURL");
        File largeFile = uploadPortletRequest.getFile("largeFile");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)ShoppingItem.class.getName(), (PortletRequest)actionRequest);
        if (itemId <= 0L) {
            ShoppingItemServiceUtil.addItem((long)groupId, (long)categoryId, (String)sku, (String)name, (String)description, (String)properties, (String)fieldsQuantities, (boolean)requiresShipping, (int)stockQuantity, (boolean)featured, sale, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (boolean)mediumImage, (String)mediumImageURL, (File)mediumFile, (boolean)largeImage, (String)largeImageURL, (File)largeFile, itemFields, itemPrices, (ServiceContext)serviceContext);
        } else {
            ShoppingItemServiceUtil.updateItem((long)itemId, (long)groupId, (long)categoryId, (String)sku, (String)name, (String)description, (String)properties, (String)fieldsQuantities, (boolean)requiresShipping, (int)stockQuantity, (boolean)featured, sale, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (boolean)mediumImage, (String)mediumImageURL, (File)mediumFile, (boolean)largeImage, (String)largeImageURL, (File)largeFile, itemFields, itemPrices, (ServiceContext)serviceContext);
        }
    }
}

