/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.portlet.SettingsConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends SettingsConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.validateEmail(actionRequest, "emailOrderConfirmation");
        this.validateEmail(actionRequest, "emailOrderShipping");
        this.validateEmailFrom(actionRequest);
        this.updatePayment(actionRequest);
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected void updateInsuranceCalculation(ActionRequest actionRequest) {
        String[] insurance = new String[5];
        for (int i = 0; i < insurance.length; ++i) {
            insurance[i] = String.valueOf(ParamUtil.getDouble((PortletRequest)actionRequest, (String)("insurance" + i)));
        }
        this.setPreference((PortletRequest)actionRequest, "insurance", insurance);
    }

    protected void updateMultiValuedKeys(ActionRequest actionRequest) {
        super.updateMultiValuedKeys(actionRequest);
        this.updateInsuranceCalculation(actionRequest);
        this.updateShippingCalculation(actionRequest);
    }

    protected void updatePayment(ActionRequest actionRequest) {
        String taxRatePercent = ParamUtil.getString((PortletRequest)actionRequest, (String)"taxRate");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        NumberFormat percentFormat = NumberFormat.getPercentInstance(themeDisplay.getLocale());
        try {
            double taxRate = GetterUtil.getDouble((Object)percentFormat.parse(taxRatePercent));
            this.setPreference((PortletRequest)actionRequest, "taxRate", String.valueOf(taxRate));
        }
        catch (ParseException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"taxRate");
        }
    }

    protected void updateShippingCalculation(ActionRequest actionRequest) {
        String[] shipping = new String[5];
        for (int i = 0; i < shipping.length; ++i) {
            shipping[i] = String.valueOf(ParamUtil.getDouble((PortletRequest)actionRequest, (String)("shipping" + i)));
        }
        this.setPreference((PortletRequest)actionRequest, "shipping", shipping);
    }
}

