/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.shopping.BillingCityException;
import com.liferay.portlet.shopping.BillingCountryException;
import com.liferay.portlet.shopping.BillingEmailAddressException;
import com.liferay.portlet.shopping.BillingFirstNameException;
import com.liferay.portlet.shopping.BillingLastNameException;
import com.liferay.portlet.shopping.BillingPhoneException;
import com.liferay.portlet.shopping.BillingStateException;
import com.liferay.portlet.shopping.BillingStreetException;
import com.liferay.portlet.shopping.BillingZipException;
import com.liferay.portlet.shopping.CCExpirationException;
import com.liferay.portlet.shopping.CCNameException;
import com.liferay.portlet.shopping.CCNumberException;
import com.liferay.portlet.shopping.CCTypeException;
import com.liferay.portlet.shopping.NoSuchOrderException;
import com.liferay.portlet.shopping.ShippingCityException;
import com.liferay.portlet.shopping.ShippingCountryException;
import com.liferay.portlet.shopping.ShippingEmailAddressException;
import com.liferay.portlet.shopping.ShippingFirstNameException;
import com.liferay.portlet.shopping.ShippingLastNameException;
import com.liferay.portlet.shopping.ShippingPhoneException;
import com.liferay.portlet.shopping.ShippingStateException;
import com.liferay.portlet.shopping.ShippingStreetException;
import com.liferay.portlet.shopping.ShippingZipException;
import com.liferay.portlet.shopping.ShoppingSettings;
import com.liferay.portlet.shopping.action.CartAction;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.service.ShoppingOrderLocalServiceUtil;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class CheckoutAction
extends CartAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        if (this.redirectToLogin(actionRequest, actionResponse)) {
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("checkout")) {
            this.checkout(actionRequest);
            this.setForward((PortletRequest)actionRequest, "portlet.shopping.checkout_first");
        } else if (!this.hasLatestOrder(actionRequest)) {
            this.setForward((PortletRequest)actionRequest, "portlet.shopping.checkout_third");
        } else if (cmd.equals("save")) {
            this.saveLatestOrder(actionRequest, actionResponse);
        } else if (cmd.equals("update")) {
            try {
                this.updateLatestOrder(actionRequest);
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.checkout_second");
            }
            catch (Exception e) {
                if (e instanceof BillingCityException || e instanceof BillingCountryException || e instanceof BillingEmailAddressException || e instanceof BillingFirstNameException || e instanceof BillingLastNameException || e instanceof BillingPhoneException || e instanceof BillingStateException || e instanceof BillingStreetException || e instanceof BillingZipException || e instanceof CCExpirationException || e instanceof CCNameException || e instanceof CCNumberException || e instanceof CCTypeException || e instanceof ShippingCityException || e instanceof ShippingCountryException || e instanceof ShippingEmailAddressException || e instanceof ShippingFirstNameException || e instanceof ShippingLastNameException || e instanceof ShippingPhoneException || e instanceof ShippingStateException || e instanceof ShippingStreetException || e instanceof ShippingZipException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                    this.setForward((PortletRequest)actionRequest, "portlet.shopping.checkout_first");
                }
                if (e instanceof PrincipalException) {
                    this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
                }
                throw e;
            }
        } else if (cmd.equals("view")) {
            this.setForward((PortletRequest)actionRequest, "portlet.shopping.checkout_third");
        } else {
            this.setForward((PortletRequest)actionRequest, "portlet.shopping.checkout_first");
        }
    }

    protected void checkout(ActionRequest actionRequest) throws Exception {
        if (!this.hasLatestOrder(actionRequest)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            ShoppingOrderLocalServiceUtil.addLatestOrder((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId());
        }
    }

    protected void forwardCheckout(ActionRequest actionRequest, ActionResponse actionResponse, ShoppingOrder order) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ShoppingCart cart = ShoppingUtil.getCart((PortletRequest)actionRequest);
        ShoppingSettings shoppingSettings = ShoppingSettings.getInstance(themeDisplay.getScopeGroupId());
        String returnURL = ShoppingUtil.getPayPalReturnURL(((ActionResponseImpl)actionResponse).createActionURL(), order);
        String notifyURL = ShoppingUtil.getPayPalNotifyURL(themeDisplay);
        if (shoppingSettings.usePayPal()) {
            double total = ShoppingUtil.calculateTotal(cart.getItems(), order.getBillingState(), cart.getCoupon(), cart.getAltShipping(), cart.isInsure());
            String redirectURL = ShoppingUtil.getPayPalRedirectURL(shoppingSettings, order, total, returnURL, notifyURL);
            actionResponse.sendRedirect(redirectURL);
        } else {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
            ShoppingOrderLocalServiceUtil.sendEmail((ShoppingOrder)order, (String)"confirmation", (ServiceContext)serviceContext);
            actionResponse.sendRedirect(returnURL);
        }
    }

    protected boolean hasLatestOrder(ActionRequest actionRequest) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            ShoppingOrderLocalServiceUtil.getLatestOrder((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId());
            return true;
        }
        catch (NoSuchOrderException nsoe) {
            return false;
        }
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void saveLatestOrder(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ShoppingCart cart = ShoppingUtil.getCart((PortletRequest)actionRequest);
        ShoppingOrder order = ShoppingOrderLocalServiceUtil.saveLatestOrder((ShoppingCart)cart);
        this.forwardCheckout(actionRequest, actionResponse, order);
    }

    protected void updateLatestOrder(ActionRequest actionRequest) throws Exception {
        String shippingStateSel;
        String billingStateSel;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String billingFirstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingFirstName");
        String billingLastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingLastName");
        String billingEmailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingEmailAddress");
        String billingCompany = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingCompany");
        String billingStreet = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingStreet");
        String billingCity = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingCity");
        String billingState = billingStateSel = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingStateSel");
        if (Validator.isNull((String)billingStateSel)) {
            billingState = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingState");
        }
        String billingZip = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingZip");
        String billingCountry = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingCountry");
        String billingPhone = ParamUtil.getString((PortletRequest)actionRequest, (String)"billingPhone");
        boolean shipToBilling = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"shipToBilling");
        String shippingFirstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingFirstName");
        String shippingLastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingLastName");
        String shippingEmailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingEmailAddress");
        String shippingCompany = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingCompany");
        String shippingStreet = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingStreet");
        String shippingCity = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingCity");
        String shippingState = shippingStateSel = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingStateSel");
        if (Validator.isNull((String)shippingStateSel)) {
            shippingState = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingState");
        }
        String shippingZip = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingZip");
        String shippingCountry = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingCountry");
        String shippingPhone = ParamUtil.getString((PortletRequest)actionRequest, (String)"shippingPhone");
        String ccName = ParamUtil.getString((PortletRequest)actionRequest, (String)"ccName");
        String ccType = ParamUtil.getString((PortletRequest)actionRequest, (String)"ccType");
        String ccNumber = ParamUtil.getString((PortletRequest)actionRequest, (String)"ccNumber");
        int ccExpMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"ccExpMonth");
        int ccExpYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"ccExpYear");
        String ccVerNumber = ParamUtil.getString((PortletRequest)actionRequest, (String)"ccVerNumber");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        ShoppingOrderLocalServiceUtil.updateLatestOrder((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)billingFirstName, (String)billingLastName, (String)billingEmailAddress, (String)billingCompany, (String)billingStreet, (String)billingCity, (String)billingState, (String)billingZip, (String)billingCountry, (String)billingPhone, (boolean)shipToBilling, (String)shippingFirstName, (String)shippingLastName, (String)shippingEmailAddress, (String)shippingCompany, (String)shippingStreet, (String)shippingCity, (String)shippingState, (String)shippingZip, (String)shippingCountry, (String)shippingPhone, (String)ccName, (String)ccType, (String)ccNumber, (int)ccExpMonth, (int)ccExpYear, (String)ccVerNumber, (String)comments);
    }
}

