/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class ShoppingSettings {
    public static final String[] ALL_KEYS = new String[]{"alternativeShipping", "ccTypes", "currencyId", "emailFromAddress", "emailFromName", "emailOrderConfirmationBody", "emailOrderConfirmationSubject", "emailOrderShippingBody", "emailOrderShippingSubject", "insurance", "insuranceFormula", "minOrder", "paypalEmailAddress", "shipping", "shippingFormula", "taxRate", "taxState", "emailOrderConfirmationEnabled", "emailOrderShippingEnabled"};
    public static final String CC_NONE = "none";
    public static final String[] CC_TYPES = new String[]{"visa", "mastercard", "discover", "amex"};
    public static final String[] CURRENCY_IDS;
    public static final double[] INSURANCE_RANGE;
    public static final double[] SHIPPING_RANGE;
    private static final String[] _MULTI_VALUED_KEYS;
    private TypedSettings _typedSettings;

    public static ShoppingSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.shopping");
        return new ShoppingSettings(settings);
    }

    public static ShoppingSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.shopping");
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new ShoppingSettings((Settings)parameterMapSettings);
    }

    public ShoppingSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String[][] getAlternativeShipping() {
        String value = this._typedSettings.getValue("alternativeShipping", null);
        if (value == null) {
            return new String[0][0];
        }
        String[] array = StringUtil.split((String)"alternativeShipping", (String)"[$_ARRAY_$]");
        String[][] alternativeShipping = new String[array.length][0];
        for (int i = 0; i < array.length; ++i) {
            alternativeShipping[i] = StringUtil.split((String)array[i]);
        }
        return alternativeShipping;
    }

    public String getAlternativeShippingName(int altShipping) {
        String altShippingName = "";
        try {
            altShippingName = this.getAlternativeShipping()[0][altShipping];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return altShippingName;
    }

    public String[] getCcTypes() {
        String[] ccTypes = this._typedSettings.getValues("ccTypes");
        if (ccTypes.length == 1 && ccTypes[0].equals(CC_NONE)) {
            return StringPool.EMPTY_ARRAY;
        }
        return ccTypes;
    }

    public String getCurrencyId() {
        return this._typedSettings.getValue("currencyId", "USD");
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public LocalizedValuesMap getEmailOrderConfirmationBody() {
        LocalizedValuesMap emailOrderConfirmationBody = this._typedSettings.getLocalizedValuesMap("emailOrderConfirmationBody");
        return emailOrderConfirmationBody;
    }

    public String getEmailOrderConfirmationBodyXml() {
        LocalizedValuesMap emailOrderConfirmationBodyMap = this.getEmailOrderConfirmationBody();
        return emailOrderConfirmationBodyMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailOrderConfirmationSubject() {
        LocalizedValuesMap emailOrderConfirmationSubject = this._typedSettings.getLocalizedValuesMap("emailOrderConfirmationSubject");
        return emailOrderConfirmationSubject;
    }

    public String getEmailOrderConfirmationSubjectXml() {
        LocalizedValuesMap emailOrderConfirmationSubjectMap = this.getEmailOrderConfirmationSubject();
        return emailOrderConfirmationSubjectMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailOrderShippingBody() {
        return this._typedSettings.getLocalizedValuesMap("emailOrderShippingBody");
    }

    public String getEmailOrderShippingBodyXml() {
        LocalizedValuesMap emailOrderShippingBodyMap = this.getEmailOrderShippingBody();
        return emailOrderShippingBodyMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailOrderShippingSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailOrderShippingSubject");
    }

    public String getEmailOrderShippingSubjectXml() {
        LocalizedValuesMap emailOrderShippingSubjectMap = this.getEmailOrderShippingSubject();
        return emailOrderShippingSubjectMap.getLocalizationXml();
    }

    public String[] getInsurance() {
        return this._typedSettings.getValues("insurance");
    }

    public String getInsuranceFormula() {
        return this._typedSettings.getValue("insuranceFormula");
    }

    public double getMinOrder() {
        return this._typedSettings.getDoubleValue("minOrder");
    }

    public String getPayPalEmailAddress() {
        return this._typedSettings.getValue("paypalEmailAddress");
    }

    public String[] getShipping() {
        return this._typedSettings.getValues("shipping");
    }

    public String getShippingFormula() {
        return this._typedSettings.getValue("shippingFormula");
    }

    public double getTaxRate() {
        return this._typedSettings.getDoubleValue("taxRate");
    }

    public String getTaxState() {
        return this._typedSettings.getValue("taxState");
    }

    public boolean isEmailOrderConfirmationEnabled() {
        return this._typedSettings.getBooleanValue("emailOrderConfirmationEnabled");
    }

    public boolean isEmailOrderShippingEnabled() {
        return this._typedSettings.getBooleanValue("emailOrderShippingEnabled");
    }

    public boolean useAlternativeShipping() {
        String[][] alternativeShipping = this.getAlternativeShipping();
        try {
            for (int i = 0; i < 10; ++i) {
                if (!Validator.isNotNull((String)alternativeShipping[0][i]) || !Validator.isNotNull((String)alternativeShipping[1][i])) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean usePayPal() {
        return Validator.isNotNull((String)this.getPayPalEmailAddress());
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("ccTypes", new String[]{"shopping.credit.card.types"});
        fallbackKeys.add("currencyId", new String[]{"shopping.currency.id"});
        fallbackKeys.add("emailFromAddress", new String[]{"shopping.email.from.address", "admin.email.from.address"});
        fallbackKeys.add("emailFromName", new String[]{"shopping.email.from.name", "admin.email.from.name"});
        fallbackKeys.add("emailOrderConfirmationBody", new String[]{"shopping.email.order.confirmation.body"});
        fallbackKeys.add("emailOrderConfirmationEnabled", new String[]{"shopping.email.order.confirmation.enabled"});
        fallbackKeys.add("emailOrderConfirmationSubject", new String[]{"shopping.email.order.confirmation.subject"});
        fallbackKeys.add("emailOrderShippingBody", new String[]{"shopping.email.order.shipping.body"});
        fallbackKeys.add("emailOrderShippingEnabled", new String[]{"shopping.email.order.shipping.enabled"});
        fallbackKeys.add("emailOrderShippingSubject", new String[]{"shopping.email.order.shipping.subject"});
        fallbackKeys.add("insurance", new String[]{"shopping.insurance"});
        fallbackKeys.add("insuranceFormula", new String[]{"shopping.insurance.formula"});
        fallbackKeys.add("minOrder", new String[]{"shopping.min.order"});
        fallbackKeys.add("paypalEmailAddress", new String[]{"shopping.paypal.email.address"});
        fallbackKeys.add("shipping", new String[]{"shopping.shipping"});
        fallbackKeys.add("shippingFormula", new String[]{"shopping.shipping.formula"});
        fallbackKeys.add("taxRate", new String[]{"shopping.tax.rate"});
        fallbackKeys.add("taxState", new String[]{"shopping.tax.state"});
        return fallbackKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        INSURANCE_RANGE = new double[]{0.01, 9.99, 10.0, 49.99, 50.0, 99.99, 100.0, 199.99, 200.0, Double.POSITIVE_INFINITY};
        SHIPPING_RANGE = new double[]{0.01, 9.99, 10.0, 49.99, 50.0, 99.99, 100.0, 199.99, 200.0, Double.POSITIVE_INFINITY};
        String[] ids = null;
        try {
            TreeSet<String> set = new TreeSet<String>();
            Locale[] locales = Locale.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                if (locale.getCountry().length() != 2) continue;
                Currency currency = Currency.getInstance(locale);
                String currencyId = currency.getCurrencyCode();
                set.add(currencyId);
            }
            ids = set.toArray(new String[set.size()]);
        }
        catch (Exception e) {
            ids = new String[]{"USD", "CAD", "EUR", "GBP", "JPY"};
        }
        finally {
            CURRENCY_IDS = ids;
        }
        _MULTI_VALUED_KEYS = new String[]{"ccTypes", "insurance", "shipping"};
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("com.liferay.portlet.shopping", ShoppingSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

