/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Role;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.rolesadmin.search.RoleDisplayTerms;
import com.liferay.portlet.rolesadmin.search.RoleSearchTerms;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class RoleSearch
extends SearchContainer<Role> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-roles-were-found";
    public static List<String> headerNames = new ArrayList<String>();
    public static Map<String, String> orderableHeaders = new HashMap<String, String>();
    private static Log _log;

    public RoleSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new RoleDisplayTerms(portletRequest), (DisplayTerms)new RoleSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        RoleDisplayTerms displayTerms = (RoleDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("type", String.valueOf(displayTerms.getType()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("128", "roles-order-by-col", orderByCol);
                preferences.setValue("128", "roles-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("128", "roles-order-by-col", "title");
                orderByType = preferences.getValue("128", "roles-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = UsersAdminUtil.getRoleOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    static {
        headerNames.add("title");
        headerNames.add("type");
        if (PropsValues.ROLES_ORGANIZATION_SUBTYPES.length > 0 || PropsValues.ROLES_REGULAR_SUBTYPES.length > 0 || PropsValues.ROLES_SITE_SUBTYPES.length > 0) {
            headerNames.add("subtype");
        }
        headerNames.add("description");
        orderableHeaders.put("title", "title");
        orderableHeaders.put("type", "type");
        orderableHeaders.put("description", "description");
        _log = LogFactoryUtil.getLog(RoleSearch.class);
    }
}

