/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.ratings.EntryScoreException;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.RatingsStats;
import com.liferay.portlet.ratings.service.base.RatingsEntryLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class RatingsEntryLocalServiceImpl
extends RatingsEntryLocalServiceBaseImpl {
    public void deleteEntry(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry == null) {
            return;
        }
        double oldScore = entry.getScore();
        this.ratingsEntryPersistence.removeByU_C_C(userId, classNameId, classPK);
        RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
        int totalEntries = stats.getTotalEntries() - 1;
        double totalScore = stats.getTotalScore() - oldScore;
        double averageScore = 0.0;
        if (totalEntries > 0) {
            averageScore = totalScore / (double)totalEntries;
        }
        stats.setTotalEntries(totalEntries);
        stats.setTotalScore(totalScore);
        stats.setAverageScore(averageScore);
        this.ratingsStatsPersistence.update((BaseModel)stats);
    }

    public RatingsEntry fetchEntry(long userId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
    }

    public List<RatingsEntry> getEntries(long userId, String className, List<Long> classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryFinder.findByU_C_C(userId, classNameId, classPKs);
    }

    public List<RatingsEntry> getEntries(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByC_C(classNameId, classPK);
    }

    public List<RatingsEntry> getEntries(String className, long classPK, double score) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByC_C_S(classNameId, classPK, score);
    }

    public int getEntriesCount(String className, long classPK, double score) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.countByC_C_S(classNameId, classPK, score);
    }

    public RatingsEntry getEntry(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPK);
    }

    public RatingsEntry updateEntry(long userId, String className, long classPK, double score, ServiceContext serviceContext) throws PortalException {
        AssetEntry assetEntry;
        boolean newEntry = false;
        long classNameId = this.classNameLocalService.getClassNameId(className);
        double oldScore = 0.0;
        Date now = new Date();
        this.validate(className, score);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry != null) {
            oldScore = entry.getScore();
            entry.setModifiedDate(serviceContext.getModifiedDate(now));
            entry.setScore(score);
            this.ratingsEntryPersistence.update((BaseModel)entry);
            RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
            stats.setTotalScore(stats.getTotalScore() - oldScore + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update((BaseModel)stats);
        } else {
            newEntry = true;
            User user = this.userPersistence.findByPrimaryKey(userId);
            long entryId = this.counterLocalService.increment();
            entry = this.ratingsEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setCreateDate(serviceContext.getCreateDate(now));
            entry.setModifiedDate(serviceContext.getModifiedDate(now));
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setScore(score);
            this.ratingsEntryPersistence.update((BaseModel)entry);
            RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
            stats.setTotalEntries(stats.getTotalEntries() + 1);
            stats.setTotalScore(stats.getTotalScore() + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update((BaseModel)stats);
        }
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            BlogsStatsUser blogsStatsUser = this.blogsStatsUserLocalService.getStatsUser(blogsEntry.getGroupId(), blogsEntry.getUserId());
            int ratingsTotalEntries = blogsStatsUser.getRatingsTotalEntries();
            double ratingsTotalScore = blogsStatsUser.getRatingsTotalScore();
            double ratingsAverageScore = blogsStatsUser.getRatingsAverageScore();
            if (newEntry) {
                ++ratingsTotalEntries;
                ratingsTotalScore += score;
            } else {
                ratingsTotalScore = ratingsTotalScore - oldScore + score;
            }
            ratingsAverageScore = ratingsTotalScore / (double)ratingsTotalEntries;
            blogsStatsUser.setRatingsTotalEntries(ratingsTotalEntries);
            blogsStatsUser.setRatingsTotalScore(ratingsTotalScore);
            blogsStatsUser.setRatingsAverageScore(ratingsAverageScore);
            this.blogsStatsUserPersistence.update((BaseModel)blogsStatsUser);
        }
        if ((assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK)) != null) {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", assetEntry.getTitle());
            this.socialActivityLocalService.addActivity(userId, assetEntry.getGroupId(), className, classPK, 10004, extraDataJSONObject.toString(), 0L);
        }
        return entry;
    }

    protected void validate(String className, double score) throws PortalException {
        Filter filter = new Filter(className);
        double maxScore = GetterUtil.getInteger((String)PropsUtil.get((String)"ratings.max.score", (Filter)filter), (int)PropsValues.RATINGS_DEFAULT_NUMBER_OF_STARS);
        double minScore = GetterUtil.getInteger((String)PropsUtil.get((String)"ratings.min.score", (Filter)filter));
        if (score < minScore || score > maxScore) {
            throw new EntryScoreException();
        }
    }
}

