/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.service.RatingsEntryLocalServiceUtil;
import java.util.Map;

public class RatingsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<RatingsEntry> {
    public static final String[] CLASS_NAMES = new String[]{RatingsEntry.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        RatingsEntry entry = this.fetchStagedModelByUuidAndCompanyId(uuid, group.getCompanyId());
        if (entry != null) {
            RatingsEntryLocalServiceUtil.deleteRatingsEntry((RatingsEntry)entry);
        }
    }

    public RatingsEntry fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        return RatingsEntryLocalServiceUtil.fetchRatingsEntryByUuidAndCompanyId((String)uuid, (long)companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(RatingsEntry entry) {
        return entry.getUuid();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, RatingsEntry entry) throws Exception {
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, RatingsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        Map relatedClassPKs = portletDataContext.getNewPrimaryKeysMap(entry.getClassName());
        long newClassPK = MapUtil.getLong((Map)relatedClassPKs, (long)entry.getClassPK(), (long)entry.getClassPK());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry);
        RatingsEntry importedEntry = RatingsEntryLocalServiceUtil.updateEntry((long)userId, (String)entry.getClassName(), (long)newClassPK, (double)entry.getScore(), (ServiceContext)serviceContext);
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
    }
}

