/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletdisplaytemplate.util;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletdisplaytemplate.BasePortletDisplayTemplateHandler;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.JSPSupportServlet;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplate;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.taglib.util.VelocityTaglib;
import com.liferay.taglib.util.VelocityTaglibImpl;
import com.liferay.util.freemarker.FreeMarkerTaglibFactoryUtil;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@DoPrivileged
public class PortletDisplayTemplateImpl
implements PortletDisplayTemplate {
    private static Log _log = LogFactoryUtil.getLog(PortletDisplayTemplateImpl.class);
    private Transformer _transformer = new Transformer("dynamic.data.lists.error.template", true);

    public DDMTemplate fetchDDMTemplate(long groupId, String displayStyle) {
        block7: {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)group.getCompanyId());
                String uuid = this.getDDMTemplateUuid(displayStyle);
                if (Validator.isNull((String)uuid)) {
                    return null;
                }
                try {
                    return DDMTemplateLocalServiceUtil.getDDMTemplateByUuidAndGroupId((String)uuid, (long)groupId);
                }
                catch (NoSuchTemplateException nste) {
                    try {
                        return DDMTemplateLocalServiceUtil.getDDMTemplateByUuidAndGroupId((String)uuid, (long)companyGroup.getGroupId());
                    }
                    catch (NoSuchTemplateException nste2) {
                    }
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public long getDDMTemplateGroupId(long groupId) {
        try {
            Group liveGroup;
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                group = group.getParentGroup();
            }
            if (group.isStagingGroup() && !(liveGroup = group.getLiveGroup()).isStagedPortlet("183")) {
                return liveGroup.getGroupId();
            }
            return group.getGroupId();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return groupId;
        }
    }

    public String getDDMTemplateUuid(String displayStyle) {
        if (!displayStyle.startsWith("ddmTemplate_")) {
            return null;
        }
        return displayStyle.substring("ddmTemplate_".length());
    }

    public long getPortletDisplayTemplateDDMTemplateId(long groupId, String displayStyle) {
        DDMTemplate portletDisplayDDMTemplate;
        long portletDisplayDDMTemplateId = 0L;
        long portletDisplayDDMTemplateGroupId = this.getDDMTemplateGroupId(groupId);
        if (displayStyle.startsWith("ddmTemplate_") && (portletDisplayDDMTemplate = this.fetchDDMTemplate(portletDisplayDDMTemplateGroupId, displayStyle)) != null) {
            portletDisplayDDMTemplateId = portletDisplayDDMTemplate.getTemplateId();
        }
        return portletDisplayDDMTemplateId;
    }

    public List<TemplateHandler> getPortletDisplayTemplateHandlers() {
        List templateHandlers = TemplateHandlerRegistryUtil.getTemplateHandlers();
        ArrayList<TemplateHandler> portletDisplayTemplateHandlers = new ArrayList<TemplateHandler>();
        for (TemplateHandler templateHandler : templateHandlers) {
            ClassLoaderBeanHandler classLoaderBeanHandler;
            Object bean;
            InvocationHandler invocationHandler;
            if (templateHandler instanceof BasePortletDisplayTemplateHandler) {
                portletDisplayTemplateHandlers.add(templateHandler);
                continue;
            }
            if (!ProxyUtil.isProxyClass(templateHandler.getClass()) || !((invocationHandler = ProxyUtil.getInvocationHandler((Object)templateHandler)) instanceof ClassLoaderBeanHandler) || !((bean = (classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler).getBean()) instanceof BasePortletDisplayTemplateHandler)) continue;
            portletDisplayTemplateHandlers.add(templateHandler);
        }
        return portletDisplayTemplateHandlers;
    }

    public Map<String, TemplateVariableGroup> getTemplateVariableGroups(String language) {
        LinkedHashMap<String, TemplateVariableGroup> templateVariableGroups = new LinkedHashMap<String, TemplateVariableGroup>();
        TemplateVariableGroup fieldsTemplateVariableGroup = new TemplateVariableGroup("fields");
        fieldsTemplateVariableGroup.addCollectionVariable("entries", List.class, "entries", "entries-item", null, "curEntry", null);
        fieldsTemplateVariableGroup.addVariable("entry", null, "entry");
        templateVariableGroups.put("fields", fieldsTemplateVariableGroup);
        TemplateVariableGroup generalVariablesTemplateVariableGroup = new TemplateVariableGroup("general-variables");
        generalVariablesTemplateVariableGroup.addVariable("current-url", String.class, "currentURL");
        generalVariablesTemplateVariableGroup.addVariable("locale", Locale.class, "locale");
        generalVariablesTemplateVariableGroup.addVariable("portlet-preferences", Map.class, "portletPreferences");
        generalVariablesTemplateVariableGroup.addVariable("template-id", null, "template_id");
        generalVariablesTemplateVariableGroup.addVariable("theme-display", ThemeDisplay.class, "themeDisplay");
        templateVariableGroups.put("general-variables", generalVariablesTemplateVariableGroup);
        TemplateVariableGroup utilTemplateVariableGroup = new TemplateVariableGroup("util");
        utilTemplateVariableGroup.addVariable("http-request", HttpServletRequest.class, "request");
        if (language.equals("vm")) {
            utilTemplateVariableGroup.addVariable("liferay-taglib", VelocityTaglib.class, "taglibLiferay");
        }
        utilTemplateVariableGroup.addVariable("render-request", RenderRequest.class, "renderRequest");
        utilTemplateVariableGroup.addVariable("render-response", RenderResponse.class, "renderResponse");
        templateVariableGroups.put("util", utilTemplateVariableGroup);
        return templateVariableGroups;
    }

    public String renderDDMTemplate(HttpServletRequest request, HttpServletResponse response, long ddmTemplateId, List<?> entries) throws Exception {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        return this.renderDDMTemplate(request, response, ddmTemplateId, entries, contextObjects);
    }

    public String renderDDMTemplate(HttpServletRequest request, HttpServletResponse response, long ddmTemplateId, List<?> entries, Map<String, Object> contextObjects) throws Exception {
        contextObjects.put("template_id", ddmTemplateId);
        contextObjects.put("entries", entries);
        if (!entries.isEmpty()) {
            contextObjects.put("entry", entries.get(0));
        }
        contextObjects.put("locale", request.getLocale());
        contextObjects.put("request", request);
        RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
        contextObjects.put("renderRequest", renderRequest);
        RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
        contextObjects.put("renderResponse", renderResponse);
        PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)renderRequest, (MimeResponse)renderResponse);
        contextObjects.put("currentURL", currentURL.toString());
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        contextObjects.put("themeDisplay", themeDisplay);
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
        String language = ddmTemplate.getLanguage();
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)ddmTemplate.getClassNameId());
        if (templateHandler instanceof BasePortletDisplayTemplateHandler) {
            BasePortletDisplayTemplateHandler portletDisplayTemplateHandler = (BasePortletDisplayTemplateHandler)templateHandler;
            Map customContextObjects = portletDisplayTemplateHandler.getCustomContextObjects();
            for (String variableName : customContextObjects.keySet()) {
                if (contextObjects.containsKey(variableName)) continue;
                Object object = customContextObjects.get(variableName);
                if (object instanceof Class) {
                    if (language.equals("ftl")) {
                        this._addStaticClassSupportFTL(contextObjects, variableName, (Class)object);
                        continue;
                    }
                    if (!language.equals("vm")) continue;
                    this._addStaticClassSupportVM(contextObjects, variableName, (Class)object);
                    continue;
                }
                contextObjects.put(variableName, object);
            }
        }
        if (language.equals("ftl")) {
            this._addTaglibSupportFTL(contextObjects, request, response);
        } else if (language.equals("vm")) {
            this._addTaglibSupportVM(contextObjects, request, response);
        }
        contextObjects.putAll(this._getPortletPreferences(renderRequest));
        return this._transformer.transform(themeDisplay, contextObjects, ddmTemplate.getScript(), language);
    }

    private void _addStaticClassSupportFTL(Map<String, Object> contextObjects, String variableName, Class<?> variableClass) {
        block2: {
            try {
                BeansWrapper beansWrapper = BeansWrapper.getDefaultInstance();
                TemplateHashModel templateHashModel = beansWrapper.getStaticModels();
                TemplateModel templateModel = templateHashModel.get(variableClass.getCanonicalName());
                contextObjects.put(variableName, templateModel);
            }
            catch (TemplateModelException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Variable " + variableName + " registration fail"), (Throwable)e);
            }
        }
    }

    private void _addStaticClassSupportVM(Map<String, Object> contextObjects, String variableName, Class<?> variableClass) {
        contextObjects.put(variableName, variableClass);
    }

    private void _addTaglibSupportFTL(Map<String, Object> contextObjects, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSPSupportServlet genericServlet = new JSPSupportServlet(request.getServletContext());
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel((GenericServlet)genericServlet, ObjectWrapper.DEFAULT_WRAPPER);
        contextObjects.put("__FreeMarkerServlet.Application__", servletContextHashModel);
        HttpRequestHashModel requestHashModel = new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER);
        contextObjects.put("__FreeMarkerServlet.Request__", requestHashModel);
        TemplateHashModel taglibLiferayHash = FreeMarkerTaglibFactoryUtil.createTaglibFactory((ServletContext)request.getServletContext());
        contextObjects.put("taglibLiferayHash", taglibLiferayHash);
    }

    private void _addTaglibSupportVM(Map<String, Object> contextObjects, HttpServletRequest request, HttpServletResponse response) {
        contextObjects.put("taglibLiferay", this._getVelocityTaglib(request, response));
    }

    private Map<String, Object> _getPortletPreferences(RenderRequest renderRequest) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        Map map = portletPreferences.getMap();
        contextObjects.put("portletPreferences", map);
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            Object[] values = (String[])entry.getValue();
            if (ArrayUtil.isEmpty((Object[])values) || (value = values[0]) == null) continue;
            contextObjects.put((String)entry.getKey(), value);
        }
        return contextObjects;
    }

    private VelocityTaglib _getVelocityTaglib(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        try {
            VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(servletContext, request, (HttpServletResponse)new PipingServletResponse(response, response.getWriter()), null);
            return velocityTaglib;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

