/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARFileSizeException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.lar.ExportImportDateUtil;
import com.liferay.portal.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatalists.RecordSetDuplicateRecordSetKeyException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException;
import com.liferay.portlet.layoutsadmin.action.ImportLayoutsAction;
import com.liferay.portlet.portletconfiguration.action.ActionUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportImportAction
extends ImportLayoutsAction {
    private static Log _log = LogFactoryUtil.getLog(ExportImportAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        actionRequest = ActionUtil.getWrappedActionRequest(actionRequest, null);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (cmd.equals("add_temp")) {
                    this.addTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                    this.validateFile(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                } else if (cmd.equals("copy_from_live")) {
                    StagingUtil.copyFromLive((PortletRequest)actionRequest, (Portlet)portlet);
                    this.sendRedirect(actionRequest, actionResponse);
                } else if (cmd.equals("delete_temp")) {
                    this.deleteTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                } else if (cmd.equals("export")) {
                    this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                    this.exportData(actionRequest, actionResponse, portlet);
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (cmd.equals("import")) {
                    this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                    this.importData(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId());
                    SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".closeRefreshPortlet"), (Object)portlet.getPortletId());
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (cmd.equals("publish_to_live")) {
                    this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                    StagingUtil.publishToLive((PortletRequest)actionRequest, (Portlet)portlet);
                    this.sendRedirect(actionRequest, actionResponse);
                }
            }
        }
        catch (Exception e) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.handleUploadException(portletConfig, actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME + portlet.getPortletId(), e);
            }
            if (e instanceof LARFileException || e instanceof LARFileSizeException || e instanceof LARTypeException || e instanceof LocaleException || e instanceof NoSuchLayoutException || e instanceof PortletIdException || e instanceof PrincipalException || e instanceof StructureDuplicateStructureKeyException || e instanceof RecordSetDuplicateRecordSetKeyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)ExportImportAction.class.getName());
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return actionMapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(ActionUtil.getTitle(portlet, renderRequest));
        renderRequest = ActionUtil.getWrappedRenderRequest(renderRequest, null);
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.export_import"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = null;
        portletRequestDispatcher = cmd.equals("export") ? portletContext.getRequestDispatcher("/html/portlet/portlet_configuration/export_portlet_processes.jsp") : (cmd.equals("import") ? portletContext.getRequestDispatcher("/html/portlet/portlet_configuration/import_portlet_processes.jsp") : (cmd.equals("publish") ? portletContext.getRequestDispatcher("/html/portlet/portlet_configuration/publish_portlet_processes.jsp") : portletContext.getRequestDispatcher("/html/portlet/portlet_configuration/import_portlet_resources.jsp")));
        resourceRequest = ActionUtil.getWrappedResourceRequest(resourceRequest, null);
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void exportData(ActionRequest actionRequest, ActionResponse actionResponse, Portlet portlet) throws Exception {
        try {
            long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
            DateRange dateRange = ExportImportDateUtil.getDateRange((PortletRequest)actionRequest, (long)groupId, (boolean)false, (long)plid, (String)portlet.getPortletId(), (String)"all");
            LayoutServiceUtil.exportPortletInfoAsFileInBackground((String)portlet.getPortletId(), (long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate(), (String)fileName);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
    }

    @Override
    protected void importData(ActionRequest actionRequest, String fileName, InputStream inputStream) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Portlet portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        LayoutServiceUtil.importPortletInfoInBackground((String)portlet.getPortletId(), (long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), (InputStream)inputStream);
    }

    @Override
    protected MissingReferences validateFile(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Portlet portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        return LayoutServiceUtil.validateImportPortletInfo((long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), (InputStream)inputStream);
    }
}

