/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.language.AggregateResourceBundle;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.StrutsPortlet;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortletConfigurationPortlet
extends StrutsPortlet {
    private static Log _log = LogFactoryUtil.getLog(PortletConfigurationPortlet.class);
    private ThreadLocal<PortletRequest> _portletRequestThreadLocal = new AutoResetThreadLocal("_portletRequestThreadLocal");

    @Override
    public void init(PortletConfig portletConfig) throws PortletException {
        if (portletConfig instanceof PortletConfigImpl) {
            PortletConfigurationPortletPortletConfig portletConfigurationPortletPortletConfig = new PortletConfigurationPortletPortletConfig((PortletConfigImpl)portletConfig);
            super.init((PortletConfig)portletConfigurationPortletPortletConfig);
        } else {
            super.init(portletConfig);
        }
    }

    @Override
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this._portletRequestThreadLocal.set((PortletRequest)actionRequest);
        actionRequest.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
        super.processAction(actionRequest, actionResponse);
    }

    @Override
    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        this._portletRequestThreadLocal.set((PortletRequest)eventRequest);
        eventRequest.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
        super.processEvent(eventRequest, eventResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this._portletRequestThreadLocal.set((PortletRequest)renderRequest);
        renderRequest.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
        super.render(renderRequest, renderResponse);
    }

    @Override
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this._portletRequestThreadLocal.set((PortletRequest)resourceRequest);
        resourceRequest.setAttribute("javax.portlet.config", (Object)this.getPortletConfig());
        super.serveResource(resourceRequest, resourceResponse);
    }

    private class PortletConfigurationPortletPortletConfig
    extends PortletConfigImpl {
        private PortletConfigurationPortletPortletConfig(PortletConfigImpl portletConfigImpl) {
            super(portletConfigImpl.getPortlet(), portletConfigImpl.getPortletContext());
        }

        @Override
        public ResourceBundle getResourceBundle(Locale locale) {
            try {
                PortletRequest portletRequest = (PortletRequest)PortletConfigurationPortlet.this._portletRequestThreadLocal.get();
                long companyId = PortalUtil.getCompanyId((PortletRequest)portletRequest);
                String portletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"portletResource");
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletResource);
                HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
                PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
                return new AggregateResourceBundle(super.getResourceBundle(locale), portletConfig.getResourceBundle(locale));
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return super.getResourceBundle(locale);
            }
        }
    }
}

