/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portalsettings.action;

import com.liferay.portal.AccountNameException;
import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchListTypeException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.io.InputStream;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCompanyAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.validateCAS(actionRequest);
                this.validateLDAP(actionRequest);
                this.validateSocialInteractions(actionRequest);
                if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                    this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.edit_company");
                } else {
                    this.updateCompany(actionRequest);
                    this.sendRedirect(actionRequest, actionResponse);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.error");
            }
            if (e instanceof AddressCityException || e instanceof AccountNameException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof CompanyMxException || e instanceof CompanyVirtualHostException || e instanceof CompanyWebIdException || e instanceof EmailAddressException || e instanceof LocaleException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException || e instanceof PhoneNumberException || e instanceof WebsiteURLException) {
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)((Object)e);
                    SessionErrors.add((PortletRequest)actionRequest, (String)(e.getClass().getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.edit_company");
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portal_settings.edit_company"));
    }

    protected void updateCompany(ActionRequest actionRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)actionRequest);
        String virtualHostname = ParamUtil.getString((PortletRequest)actionRequest, (String)"virtualHostname");
        String mx = ParamUtil.getString((PortletRequest)actionRequest, (String)"mx");
        String homeURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"homeURL");
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] logoBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
            logoBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String legalName = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalName");
        String legalId = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalId");
        String legalType = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalType");
        String sicCode = ParamUtil.getString((PortletRequest)actionRequest, (String)"sicCode");
        String tickerSymbol = ParamUtil.getString((PortletRequest)actionRequest, (String)"tickerSymbol");
        String industry = ParamUtil.getString((PortletRequest)actionRequest, (String)"industry");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        String size = ParamUtil.getString((PortletRequest)actionRequest, (String)"size");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = ParamUtil.getString((PortletRequest)actionRequest, (String)"timeZoneId");
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        List emailAddresses = UsersAdminUtil.getEmailAddresses((ActionRequest)actionRequest);
        List phones = UsersAdminUtil.getPhones((ActionRequest)actionRequest);
        List websites = UsersAdminUtil.getWebsites((ActionRequest)actionRequest);
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"settings--");
        CompanyServiceUtil.updateCompany((long)companyId, (String)virtualHostname, (String)mx, (String)homeURL, (!deleteLogo ? 1 : 0) != 0, (byte[])logoBytes, (String)name, (String)legalName, (String)legalId, (String)legalType, (String)sicCode, (String)tickerSymbol, (String)industry, (String)type, (String)size, (String)languageId, (String)timeZoneId, (List)addresses, (List)emailAddresses, (List)phones, (List)websites, (UnicodeProperties)properties);
        PortalUtil.resetCDNHosts();
    }

    protected void validateCAS(ActionRequest actionRequest) {
        boolean casEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--cas.auth.enabled--");
        if (!casEnabled) {
            return;
        }
        String casLoginURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.login.url--");
        String casLogoutURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.logout.url--");
        String casServerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.server.name--");
        String casServerURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.server.url--");
        String casServiceURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.service.url--");
        String casNoSuchUserRedirectURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--cas.no.such.user.redirect.url--");
        if (!Validator.isUrl((String)casLoginURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casLoginURLInvalid");
        }
        if (!Validator.isUrl((String)casLogoutURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casLogoutURLInvalid");
        }
        if (Validator.isNull((String)casServerName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerNameInvalid");
        }
        if (Validator.isNotNull((String)casServerURL) && Validator.isNotNull((String)casServiceURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLAndServiceURLConflict");
        } else if (Validator.isNull((String)casServerURL) && Validator.isNull((String)casServiceURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLAndServiceURLNotSet");
        } else {
            if (Validator.isNotNull((String)casServerURL) && !Validator.isUrl((String)casServerURL)) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLInvalid");
            }
            if (Validator.isNotNull((String)casServiceURL) && !Validator.isUrl((String)casServiceURL)) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"casServiceURLInvalid");
            }
        }
        if (Validator.isNotNull((String)casNoSuchUserRedirectURL) && !Validator.isUrl((String)casNoSuchUserRedirectURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casNoSuchUserURLInvalid");
        }
    }

    protected void validateLDAP(ActionRequest actionRequest) {
        if (!PropsValues.LDAP_IMPORT_USER_PASSWORD_AUTOGENERATED) {
            return;
        }
        boolean ldapExportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--ldap.export.enabled--");
        boolean ldapImportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--ldap.import.enabled--");
        if (ldapExportEnabled && ldapImportEnabled) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"ldapExportAndImportOnPasswordAutogeneration");
        }
    }

    protected void validateSocialInteractions(ActionRequest actionRequest) {
        boolean socialInteractionsEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--socialInteractionsEnabled--");
        if (!socialInteractionsEnabled) {
            return;
        }
        boolean socialInteractionsAnyUserEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--socialInteractionsAnyUserEnabled--");
        if (socialInteractionsAnyUserEnabled) {
            return;
        }
        boolean socialInteractionsSocialRelationTypesEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--socialInteractionsSocialRelationTypesEnabled--");
        String socialInteractionsSocialRelationTypes = ParamUtil.getString((PortletRequest)actionRequest, (String)"settings--socialInteractionsSocialRelationTypes--");
        if (socialInteractionsSocialRelationTypesEnabled && Validator.isNull((String)socialInteractionsSocialRelationTypes)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"socialInteractionsSocialRelationTypes");
        }
        boolean socialInteractionsSitesEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings--socialInteractionsSitesEnabled--");
        if (!socialInteractionsSocialRelationTypesEnabled && !socialInteractionsSitesEnabled) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"socialInteractionsInvalid");
        }
    }
}

