/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import com.liferay.portlet.mobiledevicerules.service.base.MDRActionServiceBaseImpl;
import com.liferay.portlet.mobiledevicerules.service.permission.MDRRuleGroupInstancePermissionUtil;
import java.util.Locale;
import java.util.Map;

public class MDRActionServiceImpl
extends MDRActionServiceBaseImpl {
    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)ruleGroupInstanceId, (String)"UPDATE");
        return this.mdrActionLocalService.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)ruleGroupInstanceId, (String)"UPDATE");
        return this.mdrActionLocalService.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
    }

    public void deleteAction(long actionId) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)action.getRuleGroupInstanceId(), (String)"UPDATE");
        this.mdrActionLocalService.deleteAction(action);
    }

    public MDRAction fetchAction(long actionId) throws PortalException {
        MDRAction action = this.mdrActionLocalService.fetchAction(actionId);
        if (action != null) {
            MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)action.getRuleGroupInstanceId(), (String)"VIEW");
        }
        return action;
    }

    public MDRAction getAction(long actionId) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)action.getRuleGroupInstanceId(), (String)"VIEW");
        return action;
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)action.getRuleGroupInstanceId(), (String)"UPDATE");
        return this.mdrActionLocalService.updateAction(actionId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)action.getRuleGroupInstanceId(), (String)"UPDATE");
        return this.mdrActionLocalService.updateAction(actionId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
    }
}

