/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class MDRRuleGroupInstanceStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRRuleGroupInstance> {
    public static final String[] CLASS_NAMES = new String[]{MDRRuleGroupInstance.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(MDRRuleGroupInstanceStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MDRRuleGroupInstance ruleGroupInstance = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ruleGroupInstance != null) {
            MDRRuleGroupInstanceLocalServiceUtil.deleteRuleGroupInstance((MDRRuleGroupInstance)ruleGroupInstance);
        }
    }

    public MDRRuleGroupInstance fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List ruleGroupInstances = MDRRuleGroupInstanceLocalServiceUtil.getMDRRuleGroupInstancesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)ruleGroupInstances)) {
            return null;
        }
        return (MDRRuleGroupInstance)ruleGroupInstances.get(0);
    }

    public MDRRuleGroupInstance fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return MDRRuleGroupInstanceLocalServiceUtil.fetchMDRRuleGroupInstanceByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRRuleGroupInstance ruleGroupInstance) throws Exception {
        MDRRuleGroup ruleGroup = MDRRuleGroupLocalServiceUtil.getRuleGroup((long)ruleGroupInstance.getRuleGroupId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)ruleGroupInstance, (StagedModel)ruleGroup, (String)"parent");
        Element ruleGroupInstanceElement = portletDataContext.getExportDataElement((ClassedModel)ruleGroupInstance);
        String className = ruleGroupInstance.getClassName();
        if (className.equals(Layout.class.getName())) {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)ruleGroupInstance.getClassPK());
            ruleGroupInstanceElement.addAttribute("layout-uuid", layout.getUuid());
        }
        portletDataContext.addClassedModel(ruleGroupInstanceElement, ExportImportPathUtil.getModelPath((StagedModel)ruleGroupInstance), (ClassedModel)ruleGroupInstance);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRRuleGroupInstance ruleGroupInstance) throws Exception {
        long userId = portletDataContext.getUserId(ruleGroupInstance.getUserUuid());
        Map ruleGroupIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroup.class);
        Long ruleGroupId = MapUtil.getLong((Map)ruleGroupIds, (long)ruleGroupInstance.getRuleGroupId(), (long)ruleGroupInstance.getRuleGroupId());
        long classPK = 0L;
        Element ruleGroupInstanceElement = portletDataContext.getImportDataStagedModelElement((StagedModel)ruleGroupInstance);
        String layoutUuid = ruleGroupInstanceElement.attributeValue("layout-uuid");
        try {
            if (Validator.isNotNull((String)layoutUuid)) {
                Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)portletDataContext.getScopeGroupId(), (boolean)portletDataContext.isPrivateLayout());
                classPK = layout.getPrimaryKey();
            } else {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)portletDataContext.getScopeGroupId(), (boolean)portletDataContext.isPrivateLayout());
                classPK = layoutSet.getLayoutSetId();
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(5);
                sb.append("Layout ");
                sb.append(layoutUuid);
                sb.append(" is missing for rule group instance ");
                sb.append(ruleGroupInstance.getRuleGroupInstanceId());
                sb.append(", skipping this rule group instance.");
                _log.warn((Object)sb.toString());
            }
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ruleGroupInstance);
        serviceContext.setUserId(userId);
        MDRRuleGroupInstance importedRuleGroupInstance = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRuleGroupInstance existingMDRRuleGroupInstance = this.fetchStagedModelByUuidAndGroupId(ruleGroupInstance.getUuid(), portletDataContext.getScopeGroupId());
            if (existingMDRRuleGroupInstance == null) {
                serviceContext.setUuid(ruleGroupInstance.getUuid());
                importedRuleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.addRuleGroupInstance((long)portletDataContext.getScopeGroupId(), (String)ruleGroupInstance.getClassName(), (long)classPK, (long)ruleGroupId, (int)ruleGroupInstance.getPriority(), (ServiceContext)serviceContext);
            } else {
                importedRuleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.updateRuleGroupInstance((long)existingMDRRuleGroupInstance.getRuleGroupInstanceId(), (int)ruleGroupInstance.getPriority());
            }
        } else {
            importedRuleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.addRuleGroupInstance((long)portletDataContext.getScopeGroupId(), (String)ruleGroupInstance.getClassName(), (long)classPK, (long)ruleGroupId, (int)ruleGroupInstance.getPriority(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)ruleGroupInstance, (ClassedModel)importedRuleGroupInstance);
    }
}

