/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.action;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.mobiledevicerules.NoSuchRuleGroupException;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRuleGroupInstanceAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteRuleGroupInstance(actionRequest);
            } else if (cmd.equals("update")) {
                this.updateRuleGroupInstancesPriorities(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.mobile_device_rules.error");
            }
            if (e instanceof NoSuchRuleGroupException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        long ruleGroupInstanceId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"ruleGroupInstanceId");
        MDRRuleGroupInstance ruleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.fetchRuleGroupInstance((long)ruleGroupInstanceId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_INSTANCE", (Object)ruleGroupInstance);
        long ruleGroupId = BeanParamUtil.getLong((Object)ruleGroupInstance, (PortletRequest)renderRequest, (String)"ruleGroupId");
        MDRRuleGroup ruleGroup = MDRRuleGroupLocalServiceUtil.fetchRuleGroup((long)ruleGroupId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP", (Object)ruleGroup);
        return actionMapping.findForward("portlet.mobile_device_rules.edit_rule_group_instance_priorities");
    }

    protected void deleteRuleGroupInstance(ActionRequest actionRequest) throws PortalException {
        long ruleGroupInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupInstanceId");
        MDRRuleGroupInstanceServiceUtil.deleteRuleGroupInstance((long)ruleGroupInstanceId);
    }

    protected void updateRuleGroupInstancesPriorities(ActionRequest actionRequest) throws PortalException {
        String ruleGroupsInstancesJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"ruleGroupsInstancesJSON");
        JSONArray ruleGroupsInstancesJSONArray = JSONFactoryUtil.createJSONArray((String)ruleGroupsInstancesJSON);
        for (int i = 0; i < ruleGroupsInstancesJSONArray.length(); ++i) {
            JSONObject ruleGroupInstanceJSONObject = ruleGroupsInstancesJSONArray.getJSONObject(i);
            long ruleGroupInstanceId = ruleGroupInstanceJSONObject.getLong("ruleGroupInstanceId");
            int priority = ruleGroupInstanceJSONObject.getInt("priority");
            MDRRuleGroupInstanceServiceUtil.updateRuleGroupInstance((long)ruleGroupInstanceId, (int)priority);
        }
    }
}

