/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.action;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.ActionHandlerManagerUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.action.ActionHandler;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.mobile.device.rulegroup.action.impl.LayoutTemplateModificationActionHandler;
import com.liferay.portal.mobile.device.rulegroup.action.impl.SimpleRedirectActionHandler;
import com.liferay.portal.mobile.device.rulegroup.action.impl.SiteRedirectActionHandler;
import com.liferay.portal.mobile.device.rulegroup.action.impl.ThemeModificationActionHandler;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portlet.mobiledevicerules.ActionTypeException;
import com.liferay.portlet.mobiledevicerules.NoSuchActionException;
import com.liferay.portlet.mobiledevicerules.NoSuchRuleGroupException;
import com.liferay.portlet.mobiledevicerules.action.EditRuleAction;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRActionServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditActionAction
extends EditRuleAction {
    private Map<Class<?>, String> _editorJSPs = new HashMap();

    public EditActionAction() {
        this.registerEditorJSP(LayoutTemplateModificationActionHandler.class, "layout_tpl");
        this.registerEditorJSP(SimpleRedirectActionHandler.class, "simple_url");
        this.registerEditorJSP(SiteRedirectActionHandler.class, "site_url");
        this.registerEditorJSP(ThemeModificationActionHandler.class, "theme");
    }

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateAction(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteActions(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.mobile_device_rules.error");
            }
            if (e instanceof ActionTypeException || e instanceof NoSuchActionException || e instanceof NoSuchRuleGroupException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        long actionId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"actionId");
        MDRAction action = MDRActionServiceUtil.fetchAction((long)actionId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP_ACTION", (Object)action);
        String type = BeanPropertiesUtil.getString((Object)action, (String)"type");
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP_ACTION_TYPE", (Object)type);
        String editorJSP = this.getEditorJSP(type);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP_ACTION_EDITOR_JSP", (Object)editorJSP);
        long ruleGroupInstanceId = BeanParamUtil.getLong((Object)action, (PortletRequest)renderRequest, (String)"ruleGroupInstanceId");
        MDRRuleGroupInstance ruleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.getMDRRuleGroupInstance((long)ruleGroupInstanceId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP_INSTANCE", (Object)ruleGroupInstance);
        MDRRuleGroup ruleGroup = ruleGroupInstance.getRuleGroup();
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP", (Object)ruleGroup);
        return actionMapping.findForward("portlet.mobile_device_rules.edit_action");
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        long actionId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"actionId");
        MDRAction action = MDRActionServiceUtil.fetchAction((long)actionId);
        resourceRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP_ACTION", (Object)action);
        String type = ParamUtil.getString((PortletRequest)resourceRequest, (String)"type");
        this.includeEditorJSP(portletConfig, resourceRequest, resourceResponse, type);
    }

    protected void deleteActions(ActionRequest actionRequest) throws Exception {
        long[] deleteActionIds = null;
        long actionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"actionId");
        deleteActionIds = actionId > 0L ? new long[]{actionId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"actionIds"), (long)0L);
        for (long deleteActionId : deleteActionIds) {
            MDRActionServiceUtil.deleteAction((long)deleteActionId);
        }
    }

    @Override
    protected String getEditorJSP(String type) {
        ActionHandler actionHandler = ActionHandlerManagerUtil.getActionHandler((String)type);
        String editorJSP = null;
        if (actionHandler != null) {
            editorJSP = this._editorJSPs.get(actionHandler.getClass());
        }
        if (editorJSP == null) {
            editorJSP = "";
        }
        return editorJSP;
    }

    protected void registerEditorJSP(Class<?> clazz, String jspPrefix) {
        this._editorJSPs.put(clazz, "/html/portlet/mobile_device_rules/action/" + jspPrefix + ".jsp");
    }

    protected void updateAction(ActionRequest actionRequest) throws Exception {
        long actionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"actionId");
        long ruleGroupInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupInstanceId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        ActionHandler actionHandler = ActionHandlerManagerUtil.getActionHandler((String)type);
        if (actionHandler == null) {
            throw new ActionTypeException();
        }
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties(actionRequest, actionHandler.getPropertyNames());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (actionId <= 0L) {
            MDRActionServiceUtil.addAction((long)ruleGroupInstanceId, (Map)nameMap, (Map)descriptionMap, (String)type, (UnicodeProperties)typeSettingsProperties, (ServiceContext)serviceContext);
        } else {
            MDRActionServiceUtil.updateAction((long)actionId, (Map)nameMap, (Map)descriptionMap, (String)type, (UnicodeProperties)typeSettingsProperties, (ServiceContext)serviceContext);
        }
    }
}

