/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.dao.shard.ShardCallable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.MBSettings;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.util.mail.JavaMailUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class MBUtil {
    public static final String BB_CODE_EDITOR_WYSIWYG_IMPL_KEY = "editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.edit_message.bb_code.jsp";
    public static final String EMOTICONS = "/emoticons";
    public static final String MESSAGE_POP_PORTLET_PREFIX = "mb_message.";
    private static Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static void addPortletBreadcrumbEntries(long categoryId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        MBUtil.addPortletBreadcrumbEntries(category, request, renderResponse);
    }

    public static void addPortletBreadcrumbEntries(MBCategory category, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/message_boards/select_category") || strutsAction.equals("/message_boards_admin/select_category")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            portletURL.setParameter("struts_action", "/message_boards/select_category");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("categories"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/message_boards/view");
        }
        List ancestorCategories = category.getAncestors();
        Collections.reverse(ancestorCategories);
        for (MBCategory curCategory : ancestorCategories) {
            portletURL.setParameter("mbCategoryId", String.valueOf(curCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)curCategory.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)category.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(MBMessage message, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (message.getCategoryId() == -1L) {
            return;
        }
        if (message.getCategoryId() != 0L) {
            MBUtil.addPortletBreadcrumbEntries(message.getCategory(), request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)message.getSubject(), (String)portletURL.toString());
    }

    public static void collectMultipartContent(MimeMultipart multipart, MBMailMessage collector) throws Exception {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            MBUtil.collectPartContent((Part)part, collector);
        }
    }

    public static void collectPartContent(Part part, MBMailMessage mbMailMessage) throws Exception {
        Object partContent = part.getContent();
        String contentType = StringUtil.toLowerCase((String)part.getContentType());
        if (part.getDisposition() != null && StringUtil.equalsIgnoreCase((String)part.getDisposition(), (String)"attachment")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing attachment");
            }
            byte[] bytes = null;
            if (partContent instanceof String) {
                bytes = ((String)partContent).getBytes();
            } else if (partContent instanceof InputStream) {
                bytes = JavaMailUtil.getBytes((Part)part);
            }
            mbMailMessage.addBytes(part.getFileName(), bytes);
        } else if (partContent instanceof MimeMultipart) {
            MimeMultipart mimeMultipart = (MimeMultipart)partContent;
            MBUtil.collectMultipartContent(mimeMultipart, mbMailMessage);
        } else if (partContent instanceof String) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("emailPartToMBMessageBody", Boolean.TRUE);
            String messageBody = SanitizerUtil.sanitize((long)0L, (long)0L, (long)0L, (String)MBMessage.class.getName(), (long)0L, (String)contentType, (String)"ALL", (String)((String)partContent), options);
            if (contentType.startsWith("text/html")) {
                mbMailMessage.setHtmlBody(messageBody);
            } else {
                mbMailMessage.setPlainBody(messageBody);
            }
        }
    }

    public static String getAbsolutePath(PortletRequest portletRequest, long mbCategoryId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (mbCategoryId == 0L) {
            return themeDisplay.translate("home");
        }
        MBCategory mbCategory = MBCategoryLocalServiceUtil.fetchMBCategory((long)mbCategoryId);
        List categories = mbCategory.getAncestors();
        Collections.reverse(categories);
        StringBundler sb = new StringBundler(categories.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (MBCategory curCategory : categories) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curCategory.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(mbCategory.getName());
        return sb.toString();
    }

    public static String getBBCodeHTML(String msgBody, String pathThemeImages) {
        return StringUtil.replace((String)BBCodeTranslatorUtil.getHTML((String)msgBody), (String)"@theme_images_path@/emoticons", (String)(pathThemeImages + EMOTICONS));
    }

    public static long getCategoryId(HttpServletRequest request, MBCategory category) {
        long categoryId = 0L;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static long getCategoryId(HttpServletRequest request, MBMessage message) {
        long categoryId = 0L;
        if (message != null) {
            categoryId = message.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static Set<Long> getCategorySubscriptionClassPKs(long userId) {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)MBCategory.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$CATEGORY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-category-in-which-the-message-has-been-posted"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-message-board"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            definitionTerms.put("[$MAILING_LIST_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-mailing-list"));
        }
        definitionTerms.put("[$MESSAGE_BODY$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-body"));
        definitionTerms.put("[$MESSAGE_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-id"));
        definitionTerms.put("[$MESSAGE_SUBJECT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-subject"));
        definitionTerms.put("[$MESSAGE_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-url"));
        definitionTerms.put("[$MESSAGE_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-message"));
        definitionTerms.put("[$MESSAGE_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-message"));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-message-board"));
        if (!PropsValues.MESSAGE_BOARDS_EMAIL_BULK) {
            definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
            definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        }
        return definitionTerms;
    }

    public static Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-message-board"));
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            definitionTerms.put("[$MAILING_LIST_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-mailing-list"));
        }
        definitionTerms.put("[$MESSAGE_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-message"));
        definitionTerms.put("[$MESSAGE_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-message"));
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-message-board"));
        return definitionTerms;
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Document document : hits.getDocs()) {
            long categoryId = GetterUtil.getLong((String)document.get("categoryId"));
            try {
                MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Message boards search index is stale and contains category " + categoryId));
                continue;
            }
            long threadId = GetterUtil.getLong((String)document.get("threadId"));
            try {
                MBThreadLocalServiceUtil.getThread((long)threadId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Message boards search index is stale and contains thread " + threadId));
                continue;
            }
            String entryClassName = document.get("entryClassName");
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            MBMessage obj = null;
            try {
                if (entryClassName.equals(DLFileEntry.class.getName())) {
                    long classPK = GetterUtil.getLong((String)document.get("classPK"));
                    MBMessageLocalServiceUtil.getMessage((long)classPK);
                    obj = DLFileEntryLocalServiceUtil.getDLFileEntry((long)entryClassPK);
                } else if (entryClassName.equals(MBMessage.class.getName())) {
                    obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                }
                entries.add(obj);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Message boards search index is stale and contains entry {className=" + entryClassName + ", " + "classPK=" + entryClassPK + "}"));
            }
        }
        return entries;
    }

    public static long getMessageId(String mailId) {
        String temp;
        int z;
        int x = mailId.indexOf(60) + 1;
        int y = mailId.indexOf(64);
        long messageId = 0L;
        if (x > 0 && y != -1 && (z = (temp = mailId.substring(x, y)).lastIndexOf(46)) != -1) {
            messageId = GetterUtil.getLong((String)temp.substring(z + 1));
        }
        return messageId;
    }

    public static long getParentMessageId(Message message) throws Exception {
        long parentMessageId = -1L;
        String parentHeader = MBUtil.getParentMessageIdString(message);
        if (parentHeader != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent header " + parentHeader));
            }
            parentMessageId = MBUtil.getMessageId(parentHeader);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Previous message id " + parentMessageId));
            }
        }
        return parentMessageId;
    }

    public static String getParentMessageIdString(Message message) throws Exception {
        Object[] inReplyToHeaders;
        Object reference;
        int x;
        Object parentHeader = null;
        Object[] references = message.getHeader("References");
        if (ArrayUtil.isNotEmpty((Object[])references) && (x = ((String)(reference = references[0])).lastIndexOf("<mb.")) > -1) {
            int y = ((String)reference).indexOf(">", x);
            parentHeader = ((String)reference).substring(x, y);
        }
        if (parentHeader == null && ArrayUtil.isNotEmpty((Object[])(inReplyToHeaders = message.getHeader("In-Reply-To")))) {
            parentHeader = inReplyToHeaders[0];
        }
        if (Validator.isNull(parentHeader) || !((String)parentHeader).startsWith(MESSAGE_POP_PORTLET_PREFIX, 1)) {
            parentHeader = MBUtil._getParentMessageIdFromSubject(message);
        }
        return parentHeader;
    }

    public static String getReplyToAddress(long categoryId, long messageId, String mx, String defaultMailingListAddress) {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() <= 0) {
            return defaultMailingListAddress;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(MESSAGE_POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        return sb.toString();
    }

    public static String getSubjectForEmail(Message message) throws Exception {
        long parentMessageId = MBUtil.getParentMessageId(message);
        MBMessage parentMessage = MBMessageLocalServiceUtil.getMBMessage((long)parentMessageId);
        String subject = parentMessage.getSubject();
        if (subject.startsWith("RE:")) {
            return subject;
        }
        return "RE: " + parentMessage.getSubject();
    }

    public static String getSubjectWithoutMessageId(Message message) throws Exception {
        int pos;
        String subject = message.getSubject();
        String parentMessageId = MBUtil._getParentMessageIdFromSubject(message);
        if (Validator.isNotNull((String)parentMessageId) && (pos = subject.indexOf(parentMessageId)) != -1) {
            subject = subject.substring(0, pos);
        }
        return subject;
    }

    public static String[] getThreadPriority(MBSettings mbSettings, String languageId, double value, ThemeDisplay themeDisplay) throws Exception {
        String[] priorities = mbSettings.getPriorities(languageId);
        String[] priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        if (priorityPair == null) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            priorities = mbSettings.getPriorities(defaultLanguageId);
            priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        }
        return priorityPair;
    }

    public static Set<Long> getThreadSubscriptionClassPKs(long userId) {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)MBThread.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public static Date getUnbanDate(MBBan ban, int expireInterval) {
        Date banDate = ban.getCreateDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(banDate);
        cal.add(5, expireInterval);
        return cal.getTime();
    }

    public static String getUserRank(MBSettings mbSettings, String languageId, int posts) throws Exception {
        String rank = "";
        String[] ranks = mbSettings.getRanks(languageId);
        for (int i = 0; i < ranks.length; ++i) {
            String[] kvp = StringUtil.split((String)ranks[i], (char)'=');
            String kvpName = kvp[0];
            int kvpPosts = GetterUtil.getInteger((String)kvp[1]);
            if (posts < kvpPosts) break;
            rank = kvpName;
        }
        return rank;
    }

    public static String[] getUserRank(MBSettings mbSettings, String languageId, MBStatsUser statsUser) throws Exception {
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        Group group = GroupLocalServiceUtil.getGroup((long)statsUser.getGroupId());
        long companyId = group.getCompanyId();
        String[] ranks = mbSettings.getRanks(languageId);
        for (int i = 0; i < ranks.length; ++i) {
            String[] kvp = StringUtil.split((String)ranks[i], (char)'=');
            String curRank = kvp[0];
            String curRankValue = kvp[1];
            String[] curRankValueKvp = StringUtil.split((String)curRankValue, (char)':');
            if (curRankValueKvp.length <= 1) {
                int posts = GetterUtil.getInteger((String)curRankValue);
                if (posts > statsUser.getMessageCount() || posts < maxPosts) continue;
                rank[0] = curRank;
                maxPosts = posts;
                continue;
            }
            String entityType = curRankValueKvp[0];
            String entityValue = curRankValueKvp[1];
            try {
                if (!MBUtil._isEntityRank(companyId, statsUser, entityType, entityValue)) continue;
                rank[1] = curRank;
                break;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)e);
            }
        }
        return rank;
    }

    public static boolean hasMailIdHeader(Message message) throws Exception {
        String[] messageIds = message.getHeader("Message-ID");
        if (messageIds == null) {
            return false;
        }
        for (String messageId : messageIds) {
            if (!Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN) || !messageId.contains(PropsValues.POP_SERVER_SUBDOMAIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMessageFormat(String messageFormat) {
        String editorImpl = PropsUtil.get((String)BB_CODE_EDITOR_WYSIWYG_IMPL_KEY);
        return !messageFormat.equals("bbcode") || editorImpl.equals("bbcode") || editorImpl.equals("ckeditor_bbcode");
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message) throws Exception {
        return MBUtil.isViewableMessage(themeDisplay, message, message);
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message, MBMessage parentMessage) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!MBMessagePermission.contains(permissionChecker, parentMessage, "VIEW")) {
            return false;
        }
        if (message.getMessageId() != parentMessage.getMessageId() && !MBMessagePermission.contains(permissionChecker, message, "VIEW")) {
            return false;
        }
        return message.isApproved() || Validator.equals((long)message.getUserId(), (long)themeDisplay.getUserId()) || permissionChecker.isGroupAdmin(themeDisplay.getScopeGroupId());
    }

    public static void propagatePermissions(long companyId, long groupId, long parentMessageId, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage = MBMessageLocalServiceUtil.getMBMessage((long)parentMessageId);
        Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole((long)groupId);
        Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List actionIds = ResourceActionsUtil.getModelResourceActions((String)MBMessage.class.getName());
        Map roleIdsToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)MBMessage.class.getName(), (int)4, (String)String.valueOf(parentMessage.getMessageId()), (Collection)actionIds);
        Set defaultGroupActionIds = (Set)roleIdsToActionIds.get(defaultGroupRole.getRoleId());
        if (defaultGroupActionIds == null) {
            serviceContext.setGroupPermissions(new String[0]);
        } else {
            serviceContext.setGroupPermissions(defaultGroupActionIds.toArray(new String[defaultGroupActionIds.size()]));
        }
        Set guestActionIds = (Set)roleIdsToActionIds.get(guestRole.getRoleId());
        if (guestActionIds == null) {
            serviceContext.setGuestPermissions(new String[0]);
        } else {
            serviceContext.setGuestPermissions(guestActionIds.toArray(new String[guestActionIds.size()]));
        }
    }

    public static String replaceMessageBodyPaths(ThemeDisplay themeDisplay, String messageBody) {
        return StringUtil.replace((String)messageBody, (String[])new String[]{"@theme_images_path@", "href=\"/", "src=\"/"}, (String[])new String[]{themeDisplay.getPathThemeImages(), "href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
    }

    public static void updateCategoryMessageCount(long companyId, final long categoryId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    return null;
                }
                int messageCount = MBUtil._getMessageCount(category);
                category.setMessageCount(messageCount);
                MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryStatistics(long companyId, final long categoryId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    return null;
                }
                int messageCount = MBUtil._getMessageCount(category);
                int threadCount = MBThreadLocalServiceUtil.getCategoryThreadsCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
                category.setMessageCount(messageCount);
                category.setThreadCount(threadCount);
                MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryThreadCount(long companyId, final long categoryId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    return null;
                }
                int threadCount = MBThreadLocalServiceUtil.getCategoryThreadsCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
                category.setThreadCount(threadCount);
                MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    public static void updateThreadMessageCount(long companyId, final long threadId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBThread thread = MBThreadLocalServiceUtil.fetchThread((long)threadId);
                if (thread == null) {
                    return null;
                }
                int messageCount = MBMessageLocalServiceUtil.getThreadMessagesCount((long)threadId, (int)0);
                thread.setMessageCount(messageCount);
                MBThreadLocalServiceUtil.updateMBThread((MBThread)thread);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    private static String[] _findThreadPriority(double value, ThemeDisplay themeDisplay, String[] priorities) {
        for (int i = 0; i < priorities.length; ++i) {
            String[] priority = StringUtil.split((String)priorities[i], (String)"|");
            try {
                String priorityName = priority[0];
                String priorityImage = priority[1];
                double priorityValue = GetterUtil.getDouble((String)priority[2]);
                if (value != priorityValue) continue;
                if (!priorityImage.startsWith("http")) {
                    priorityImage = themeDisplay.getPathThemeImages() + priorityImage;
                }
                return new String[]{priorityName, priorityImage};
            }
            catch (Exception e) {
                _log.error((Object)"Unable to determine thread priority", (Throwable)e);
            }
        }
        return null;
    }

    private static int _getMessageCount(MBCategory category) {
        return MBMessageLocalServiceUtil.getCategoryMessagesCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
    }

    private static String _getParentMessageIdFromSubject(Message message) throws Exception {
        if (message.getSubject() == null) {
            return null;
        }
        String parentMessageId = null;
        String subject = StringUtil.reverse((String)message.getSubject());
        int pos = subject.indexOf(60);
        if (pos != -1) {
            parentMessageId = StringUtil.reverse((String)subject.substring(0, pos + 1));
        }
        return parentMessageId;
    }

    private static boolean _isEntityRank(long companyId, MBStatsUser statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        Role role;
        long groupId = statsUser.getGroupId();
        long userId = statsUser.getUserId();
        return entityType.equals("organization-role") || entityType.equals("site-role") ? UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)groupId, (long)(role = RoleLocalServiceUtil.getRole((long)companyId, (String)entityValue)).getRoleId(), (boolean)true) : (entityType.equals("organization") ? OrganizationLocalServiceUtil.hasUserOrganization((long)userId, (long)(organization = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)entityValue)).getOrganizationId(), (boolean)false, (boolean)false) : (entityType.equals("regular-role") ? RoleLocalServiceUtil.hasUserRole((long)userId, (long)companyId, (String)entityValue, (boolean)true) : entityType.equals("user-group") && UserLocalServiceUtil.hasUserGroupUser((long)(userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)entityValue)).getUserGroupId(), (long)userId)));
    }
}

