/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class MBThreadIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{MBThread.class.getName()};
    public static final String PORTLET_ID = "19";

    public MBThreadIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"classNameId", "classPK", "companyId", "entryClassName", "entryClassPK", "portletId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long participantUserId;
        this.addStatus(contextQuery, searchContext);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"), (boolean)false);
        contextQuery.addRequiredTerm("discussion", discussion);
        long endDate = GetterUtil.getLong((Object)searchContext.getAttribute("endDate"));
        long startDate = GetterUtil.getLong((Object)searchContext.getAttribute("startDate"));
        if (endDate > 0L && startDate > 0L) {
            contextQuery.addRangeTerm("lastPostDate", startDate, endDate);
        }
        if ((participantUserId = GetterUtil.getLong((Object)searchContext.getAttribute("participantUserId"))) > 0L) {
            contextQuery.addRequiredTerm("participantUserIds", participantUserId);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchEngineId(this.getSearchEngineId());
        MBThread thread = (MBThread)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, thread.getThreadId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)thread.getCompanyId(), (String)document.get("uid"), (boolean)this.isCommitImmediately());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        MBThread thread = (MBThread)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)thread);
        try {
            MBDiscussionLocalServiceUtil.getThreadDiscussion((long)thread.getThreadId());
            document.addKeyword("discussion", true);
        }
        catch (NoSuchDiscussionException nsde) {
            document.addKeyword("discussion", false);
        }
        document.addKeyword("lastPostDate", thread.getLastPostDate().getTime());
        document.addKeyword("participantUserIds", thread.getParticipantUserIds());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(Object obj) throws Exception {
        MBThread thread = (MBThread)obj;
        Document document = this.getDocument(thread);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)thread.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        this.doReindex(thread);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexDiscussions(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexCategories(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = MBCategoryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                MBCategory category = (MBCategory)object;
                MBThreadIndexer.this.reindexThreads(companyId, category.getGroupId(), category.getCategoryId());
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexDiscussions(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                Group group = (Group)object;
                MBThreadIndexer.this.reindexThreads(companyId, group.getGroupId(), -1L);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                Group group = (Group)object;
                MBThreadIndexer.this.reindexThreads(companyId, group.getGroupId(), 0L);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexThreads(long companyId, long groupId, final long categoryId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = MBThreadLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
                dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                dynamicQuery.add(statusProperty.eq((Object)0));
            }
        });
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                MBThread thread = (MBThread)object;
                Document document = MBThreadIndexer.this.getDocument(thread);
                actionableDynamicQuery.addDocument(document);
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

