/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.mail.Account;
import com.liferay.portal.kernel.mail.SMTPAccount;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.messageboards.NoSuchMailingListException;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.service.MBMailingListLocalServiceUtil;

public class MBSubscriptionSender
extends SubscriptionSender {
    private boolean _calledAddMailingListSubscriber;

    public void addMailingListSubscriber(long groupId, long categoryId) throws PortalException {
        if (this._calledAddMailingListSubscriber) {
            throw new IllegalArgumentException();
        }
        this._calledAddMailingListSubscriber = true;
        MBMailingList mailingList = null;
        try {
            mailingList = MBMailingListLocalServiceUtil.getCategoryMailingList((long)groupId, (long)categoryId);
        }
        catch (NoSuchMailingListException nsmle) {
            return;
        }
        if (!mailingList.isActive()) {
            return;
        }
        this.setFrom(mailingList.getOutEmailAddress(), null);
        this.setReplyToAddress(mailingList.getEmailAddress());
        if (mailingList.isOutCustom()) {
            String protocol = "smtp";
            if (mailingList.isOutUseSSL()) {
                protocol = "smtps";
            }
            SMTPAccount smtpAccount = (SMTPAccount)Account.getInstance((String)protocol, (int)mailingList.getOutServerPort());
            smtpAccount.setHost(mailingList.getOutServerName());
            smtpAccount.setUser(mailingList.getOutUserName());
            smtpAccount.setPassword(mailingList.getOutPassword());
            this.setSMTPAccount(smtpAccount);
        }
        this.setSubject(this.getMailingListSubject(this.subject, this.mailId));
        this.addRuntimeSubscribers(mailingList.getEmailAddress(), mailingList.getEmailAddress());
    }

    protected String getMailingListSubject(String subject, String mailId) {
        subject = GetterUtil.getString((String)subject);
        mailId = GetterUtil.getString((String)mailId);
        return subject.concat(" ").concat(mailId);
    }
}

