/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.trash.BaseTrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBTreeWalker;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class MBThreadTrashRenderer
extends BaseTrashRenderer {
    public static final String TYPE = "message_thread";
    private MBMessage _rootMessage;
    private MBThread _thread;

    public MBThreadTrashRenderer(MBThread thread) throws PortalException {
        this._thread = thread;
        this._rootMessage = MBMessageLocalServiceUtil.getMBMessage((long)thread.getRootMessageId());
    }

    public String getClassName() {
        return MBThread.class.getName();
    }

    public long getClassPK() {
        return this._thread.getPrimaryKey();
    }

    public String getIconCssClass() {
        return "icon-comments";
    }

    public String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/conversation.png";
    }

    public String getPortletId() {
        return "19";
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    public String getTitle(Locale locale) {
        return HtmlUtil.stripHtml((String)this._rootMessage.getSubject());
    }

    public String getType() {
        return TYPE;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        MBMessageDisplay messageDisplay = MBMessageServiceUtil.getMessageDisplay((long)this._rootMessage.getMessageId(), (int)-1, (String)"tree", (boolean)false);
        renderRequest.setAttribute("MESSAGE_BOARDS_MESSAGE", (Object)messageDisplay);
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER", (Object)treeWalker);
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_CATEGORY", (Object)messageDisplay.getCategory());
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_CUR_MESSAGE", (Object)treeWalker.getRoot());
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_DEPTH", (Object)new Integer(0));
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_LAST_NODE", (Object)Boolean.FALSE);
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_SEL_MESSAGE", (Object)this._rootMessage);
        renderRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_THREAD", (Object)messageDisplay.getThread());
        return "/html/portlet/message_boards/view_thread_tree.jsp";
    }
}

