/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portlet.messageboards.model.MBCategory"})
public class MBCategoryPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException {
        if (!MBCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException {
        if (!MBCategoryPermission.contains(permissionChecker, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, MBCategory category, String actionId) throws PortalException {
        if (!MBCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException {
        if (MBBanLocalServiceUtil.hasBan((long)groupId, (long)permissionChecker.getUserId())) {
            return false;
        }
        if (categoryId == 0L || categoryId == -1L) {
            return MBPermission.contains(permissionChecker, groupId, actionId);
        }
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MBCategory category, String actionId) throws PortalException {
        Boolean hasPermission;
        if (MBBanLocalServiceUtil.hasBan((long)category.getGroupId(), (long)permissionChecker.getUserId())) {
            return false;
        }
        if (actionId.equals("ADD_CATEGORY")) {
            actionId = "ADD_SUBCATEGORY";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)category.getGroupId(), (String)MBCategory.class.getName(), (long)category.getCategoryId(), (String)"19", (String)actionId)) != null) {
            return hasPermission;
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            block8: {
                try {
                    long categoryId = category.getCategoryId();
                    while (categoryId != 0L) {
                        category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                        if (!MBCategoryPermission._hasPermission(permissionChecker, category, actionId)) {
                            return false;
                        }
                        categoryId = category.getParentCategoryId();
                    }
                }
                catch (NoSuchCategoryException nsce) {
                    if (category.isInTrash()) break block8;
                    throw nsce;
                }
            }
            return MBPermission.contains(permissionChecker, category.getGroupId(), actionId);
        }
        return MBCategoryPermission._hasPermission(permissionChecker, category, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        MBCategoryPermission.check(permissionChecker, groupId, primaryKey, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, MBCategory category, String actionId) {
        return permissionChecker.hasOwnerPermission(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId) || permissionChecker.hasPermission(category.getGroupId(), MBCategory.class.getName(), category.getCategoryId(), actionId);
    }
}

