/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBThreadModelImpl;
import com.liferay.portlet.messageboards.service.base.MBThreadServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MBThreadServiceImpl
extends MBThreadServiceBaseImpl {
    public void deleteThread(long threadId) throws PortalException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.deleteThread(threadId);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, Date modifiedDate, int status, int start, int end) throws PortalException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
            return this.mbThreadFinder.findByG_U_LPD(groupId, userId, modifiedDate, queryDefinition);
        }
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        List threadIds = this.mbMessageFinder.filterFindByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator i$ = threadIds.iterator();
        while (i$.hasNext()) {
            long threadId = (Long)i$.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.doGetGroupThreads(groupId, userId, status, subscribed, includeAnonymous, start, end);
        }
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        List threadIds = null;
        if (userId <= 0L) {
            threadIds = this.mbMessageFinder.filterFindByG_U_C_S(groupId, 0L, categoryIds, status, start, end);
        } else {
            if (subscribed) {
                QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
                return this.mbThreadFinder.filterFindByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
            }
            threadIds = includeAnonymous ? this.mbMessageFinder.filterFindByG_U_C_S(groupId, userId, categoryIds, status, start, end) : this.mbMessageFinder.filterFindByG_U_C_A_S(groupId, userId, categoryIds, false, status, start, end);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator i$ = threadIds.iterator();
        while (i$.hasNext()) {
            long threadId = (Long)i$.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws PortalException {
        return this.getGroupThreads(groupId, userId, status, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws PortalException {
        return this.getGroupThreads(groupId, userId, status, false, start, end);
    }

    public int getGroupThreadsCount(long groupId, long userId, Date modifiedDate, int status) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            QueryDefinition queryDefinition = new QueryDefinition(status);
            return this.mbThreadFinder.countByG_U_LPD(groupId, userId, modifiedDate, queryDefinition);
        }
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        return this.mbMessageFinder.filterCountByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) {
        return this.getGroupThreadsCount(groupId, userId, status, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) {
        return this.getGroupThreadsCount(groupId, userId, status, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.doGetGroupThreadsCount(groupId, userId, status, subscribed, includeAnonymous);
        }
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        if (userId <= 0L) {
            return this.mbMessageFinder.filterCountByG_U_C_S(groupId, 0L, categoryIds, status);
        }
        if (subscribed) {
            QueryDefinition queryDefinition = new QueryDefinition(status);
            return this.mbThreadFinder.filterCountByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbMessageFinder.filterCountByG_U_C_S(groupId, userId, categoryIds, status);
        }
        return this.mbMessageFinder.filterCountByG_U_C_A_S(groupId, userId, categoryIds, false, status);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.mbThreadFinder.filterFindByG_C(groupId, categoryId, queryDefinition);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbThreadFinder.filterCountByG_C(groupId, categoryId);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbThreadFinder.filterCountByG_C(groupId, categoryId, queryDefinition);
    }

    public Lock lockThread(long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        return this.lockLocalService.lock(this.getUserId(), MBThread.class.getName(), threadId, String.valueOf(threadId), false, MBThreadModelImpl.LOCK_EXPIRATION_TIME);
    }

    public MBThread moveThread(long categoryId, long threadId) throws PortalException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "MOVE_THREAD");
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), categoryId, "MOVE_THREAD");
        return this.mbThreadLocalService.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public MBThread moveThreadFromTrash(long categoryId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "UPDATE");
        return this.mbThreadLocalService.moveThreadFromTrash(this.getUserId(), categoryId, threadId);
    }

    public MBThread moveThreadToTrash(long threadId) throws PortalException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        return this.mbThreadLocalService.moveThreadToTrash(this.getUserId(), threadId);
    }

    public void restoreThreadFromTrash(long threadId) throws PortalException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.restoreThreadFromTrash(this.getUserId(), threadId);
    }

    public Hits search(long groupId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.mbThreadLocalService.search(groupId, this.getUserId(), creatorUserId, status, start, end);
    }

    public Hits search(long groupId, long creatorUserId, long startDate, long endDate, int status, int start, int end) throws PortalException {
        return this.mbThreadLocalService.search(groupId, this.getUserId(), creatorUserId, startDate, endDate, status, start, end);
    }

    public MBThread splitThread(long messageId, String subject, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessageLocalService.getMessage(messageId);
        MBCategoryPermission.check(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "MOVE_THREAD");
        return this.mbThreadLocalService.splitThread(messageId, subject, serviceContext);
    }

    public void unlockThread(long threadId) throws PortalException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        this.lockLocalService.unlock(MBThread.class.getName(), threadId);
    }

    protected List<MBThread> doGetGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.findByGroupId(groupId, start, end);
            }
            return this.mbThreadPersistence.findByG_S(groupId, status, start, end);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U(groupId, userId, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.findByG_U(groupId, userId, queryDefinition);
        }
        return this.mbThreadFinder.findByG_U_A(groupId, userId, false, queryDefinition);
    }

    protected int doGetGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.countByGroupId(groupId);
            }
            return this.mbThreadPersistence.countByG_S(groupId, status);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U(groupId, userId, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.countByG_U(groupId, userId, queryDefinition);
        }
        return this.mbThreadFinder.countByG_U_A(groupId, userId, false, queryDefinition);
    }
}

