/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBThreadFlag;
import com.liferay.portlet.messageboards.service.base.MBThreadFlagLocalServiceBaseImpl;
import java.util.Date;

public class MBThreadFlagLocalServiceImpl
extends MBThreadFlagLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBThreadFlagLocalServiceImpl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addThreadFlag(long userId, MBThread thread, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return;
        }
        long threadId = thread.getThreadId();
        MBThreadFlag threadFlag = this.mbThreadFlagPersistence.fetchByU_T(userId, threadId);
        if (threadFlag == null) {
            long threadFlagId = this.counterLocalService.increment();
            threadFlag = this.mbThreadFlagPersistence.create(threadFlagId);
            threadFlag.setUuid(serviceContext.getUuid());
            threadFlag.setGroupId(thread.getGroupId());
            threadFlag.setCompanyId(user.getCompanyId());
            threadFlag.setUserId(userId);
            threadFlag.setUserName(user.getFullName());
            threadFlag.setCreateDate(serviceContext.getCreateDate(new Date()));
            threadFlag.setModifiedDate(serviceContext.getModifiedDate(thread.getLastPostDate()));
            threadFlag.setThreadId(threadId);
            try {
                this.mbThreadFlagPersistence.update((BaseModel)threadFlag);
                return;
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {userId=" + userId + ", threadId=" + threadId + "}"));
                }
                if ((threadFlag = this.mbThreadFlagPersistence.fetchByU_T(userId, threadId, false)) != null) return;
                throw se;
            }
        } else {
            if (DateUtil.equals((Date)threadFlag.getModifiedDate(), (Date)thread.getLastPostDate(), (boolean)true)) return;
            threadFlag.setModifiedDate(thread.getLastPostDate());
            this.mbThreadFlagPersistence.update((BaseModel)threadFlag);
        }
    }

    public void deleteThreadFlag(long threadFlagId) throws PortalException {
        MBThreadFlag threadFlag = this.mbThreadFlagPersistence.findByPrimaryKey(threadFlagId);
        this.mbThreadFlagLocalService.deleteThreadFlag(threadFlag);
    }

    @SystemEvent(type=1)
    public void deleteThreadFlag(MBThreadFlag threadFlag) {
        this.mbThreadFlagPersistence.remove((BaseModel)threadFlag);
    }

    public void deleteThreadFlagsByThreadId(long threadId) {
        this.mbThreadFlagPersistence.removeByThreadId(threadId);
    }

    public void deleteThreadFlagsByUserId(long userId) {
        this.mbThreadFlagPersistence.removeByUserId(userId);
    }

    public MBThreadFlag getThreadFlag(long userId, MBThread thread) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return null;
        }
        return this.mbThreadFlagPersistence.fetchByU_T(userId, thread.getThreadId());
    }

    public boolean hasThreadFlag(long userId, MBThread thread) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return true;
        }
        MBThreadFlag threadFlag = this.mbThreadFlagPersistence.fetchByU_T(userId, thread.getThreadId());
        return threadFlag != null && DateUtil.equals((Date)threadFlag.getModifiedDate(), (Date)thread.getLastPostDate(), (boolean)true);
    }
}

