/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.security.permission;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.permission.BasePermissionPropagator;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.ActionRequest;

public class MBPermissionPropagatorImpl
extends BasePermissionPropagator {
    public void propagateRolePermissions(ActionRequest actionRequest, String className, String primKey, long[] roleIds) throws PortalException {
        if (className.equals(MBCategory.class.getName())) {
            this.propagateCategoryRolePermissions(actionRequest, className, primKey, roleIds);
        } else if (className.equals(MBMessage.class.getName())) {
            long messageId = GetterUtil.getLong((String)primKey);
            MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
            if (message.isRoot()) {
                this.propagateThreadRolePermissions(actionRequest, className, messageId, message.getThreadId(), roleIds);
            }
        } else if (className.equals("com.liferay.portlet.messageboards")) {
            this.propagateMBRolePermissions(actionRequest, className, primKey, roleIds);
        }
    }

    protected void propagateCategoryRolePermissions(ActionRequest actionRequest, String className, long primaryKey, long categoryId, long[] roleIds) throws PortalException {
        for (long roleId : roleIds) {
            this.propagateRolePermissions(actionRequest, roleId, className, primaryKey, MBCategory.class.getName(), categoryId);
        }
    }

    protected void propagateCategoryRolePermissions(final ActionRequest actionRequest, final String className, String primKey, final long[] roleIds) throws PortalException {
        final long categoryId = GetterUtil.getLong((String)primKey);
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        List categoriesAndThreads = MBCategoryLocalServiceUtil.getCategoriesAndThreads((long)category.getGroupId(), (long)categoryId);
        for (Object categoryOrThread : categoriesAndThreads) {
            if (categoryOrThread instanceof MBThread) {
                MBThread thread = (MBThread)categoryOrThread;
                List messages = MBMessageLocalServiceUtil.getThreadMessages((long)thread.getThreadId(), (int)-1);
                for (MBMessage message : messages) {
                    this.propagateMessageRolePermissions(actionRequest, className, categoryId, message.getMessageId(), roleIds);
                }
                continue;
            }
            category = (MBCategory)categoryOrThread;
            List categoryIds = new ArrayList<Long>();
            categoryIds.add(category.getCategoryId());
            categoryIds = MBCategoryLocalServiceUtil.getSubcategoryIds(categoryIds, (long)category.getGroupId(), (long)category.getCategoryId());
            Iterator i$ = categoryIds.iterator();
            while (i$.hasNext()) {
                final long addCategoryId = (Long)i$.next();
                this.propagateCategoryRolePermissions(actionRequest, className, categoryId, addCategoryId, roleIds);
                ActionableDynamicQuery actionableDynamicQuery = MBMessageLocalServiceUtil.getActionableDynamicQuery();
                actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                    public void addCriteria(DynamicQuery dynamicQuery) {
                        Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
                        dynamicQuery.add(categoryIdProperty.eq((Object)addCategoryId));
                    }
                });
                actionableDynamicQuery.setGroupId(category.getGroupId());
                actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

                    public void performAction(Object object) throws PortalException {
                        MBMessage message = (MBMessage)object;
                        MBPermissionPropagatorImpl.this.propagateMessageRolePermissions(actionRequest, className, categoryId, message.getMessageId(), roleIds);
                    }
                });
                actionableDynamicQuery.performActions();
            }
        }
    }

    protected void propagateMBRolePermissions(final ActionRequest actionRequest, final String className, String primKey, final long[] roleIds) throws PortalException {
        final long groupId = GetterUtil.getLong((String)primKey);
        List categories = MBCategoryLocalServiceUtil.getCategories((long)groupId);
        for (MBCategory category : categories) {
            this.propagateCategoryRolePermissions(actionRequest, className, groupId, category.getCategoryId(), roleIds);
        }
        ActionableDynamicQuery actionableDynamicQuery = MBMessageLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                MBMessage message = (MBMessage)object;
                MBPermissionPropagatorImpl.this.propagateMessageRolePermissions(actionRequest, className, groupId, message.getMessageId(), roleIds);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void propagateMessageRolePermissions(ActionRequest actionRequest, String className, long primaryKey, long messageId, long[] roleIds) throws PortalException {
        for (long roleId : roleIds) {
            this.propagateRolePermissions(actionRequest, roleId, className, primaryKey, MBMessage.class.getName(), messageId);
        }
    }

    protected void propagateThreadRolePermissions(ActionRequest actionRequest, String className, long messageId, long threadId, long[] roleIds) throws PortalException {
        List messages = MBMessageLocalServiceUtil.getThreadMessages((long)threadId, (int)-1);
        for (MBMessage message : messages) {
            this.propagateMessageRolePermissions(actionRequest, className, messageId, message.getMessageId(), roleIds);
        }
    }
}

