/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.pop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.time.StopWatch;

public class MessageListenerImpl
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MessageListenerImpl.class);

    public boolean accept(String from, String recipient, Message message) {
        try {
            String pop3User;
            if (this.isAutoReply(message)) {
                return false;
            }
            String messageIdString = this.getMessageIdString(recipient, message);
            if (messageIdString == null || !messageIdString.startsWith("mb_message.", this.getOffset())) {
                return false;
            }
            Company company = this.getCompany(messageIdString);
            long categoryId = this.getCategoryId(messageIdString);
            MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            if (category.getCompanyId() != company.getCompanyId() && !category.isRoot()) {
                return false;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Check to see if user " + from + " exists"));
            }
            if (StringUtil.equalsIgnoreCase((String)from, (String)(pop3User = PrefsPropsUtil.getString((String)"mail.session.mail.pop3.user", (String)PropsValues.MAIL_SESSION_MAIL_POP3_USER)))) {
                return false;
            }
            UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
            return true;
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Unable to process message: " + message), (Throwable)e);
            }
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliver(String from, String recipient, Message message) throws MessageListenerException {
        block22: {
            Iterator<ObjectValuePair<String, InputStream>> i$;
            List<ObjectValuePair<String, InputStream>> inputStreamOVPs = null;
            try {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Deliver message from " + from + " to " + recipient));
                }
                String messageIdString = this.getMessageIdString(recipient, message);
                Company company = this.getCompany(messageIdString);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Message id " + messageIdString));
                }
                long groupId = 0L;
                long categoryId = this.getCategoryId(messageIdString);
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    groupId = categoryId;
                    categoryId = 0L;
                } else {
                    long messageId;
                    MBMessage threadMessage;
                    groupId = category.getGroupId();
                    if (category.isRoot() && (threadMessage = MBMessageLocalServiceUtil.fetchMBMessage((long)(messageId = this.getMessageId(messageIdString)))) != null) {
                        groupId = threadMessage.getGroupId();
                    }
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Group id " + groupId));
                    _log.debug((Object)("Category id " + categoryId));
                }
                User user = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
                long parentMessageId = this.getParentMessageId(recipient, message);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Parent message id " + parentMessageId));
                }
                MBMessage parentMessage = null;
                try {
                    if (parentMessageId > 0L) {
                        parentMessage = MBMessageLocalServiceUtil.getMessage((long)parentMessageId);
                    }
                }
                catch (NoSuchMessageException nsme) {
                    // empty catch block
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Parent message " + parentMessage));
                }
                String subject = MBUtil.getSubjectForEmail(message);
                MBMailMessage mbMailMessage = new MBMailMessage();
                MBUtil.collectPartContent((Part)message, mbMailMessage);
                inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
                PermissionCheckerUtil.setThreadValues(user);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAttribute("propagatePermissions", (Serializable)Boolean.TRUE);
                serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)"19", (boolean)StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL)));
                serviceContext.setScopeGroupId(groupId);
                if (parentMessage == null) {
                    MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                } else {
                    MBMessageServiceUtil.addMessage((long)parentMessage.getMessageId(), (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Delivering message takes " + stopWatch.getTime() + " ms"));
                }
                if (inputStreamOVPs == null) break block22;
                i$ = inputStreamOVPs.iterator();
            }
            catch (PrincipalException pe) {
                try {
                    if (!_log.isDebugEnabled()) throw new MessageListenerException((Throwable)pe);
                    _log.debug((Object)("Prevented unauthorized post from " + from));
                    throw new MessageListenerException((Throwable)pe);
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                        throw new MessageListenerException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (inputStreamOVPs != null) {
                        for (ObjectValuePair objectValuePair : inputStreamOVPs) {
                            InputStream inputStream = (InputStream)objectValuePair.getValue();
                            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        }
                    }
                    PermissionCheckerUtil.setThreadValues(null);
                    throw throwable;
                }
            }
            while (i$.hasNext()) {
                ObjectValuePair<String, InputStream> inputStreamOVP = i$.next();
                InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
        }
        PermissionCheckerUtil.setThreadValues(null);
    }

    public String getId() {
        return MessageListenerImpl.class.getName();
    }

    protected long getCategoryId(String messageIdString) {
        String[] parts = this.getMessageIdStringParts(messageIdString);
        return GetterUtil.getLong((String)parts[0]);
    }

    protected Company getCompany(String messageIdString) throws Exception {
        int endPos;
        int pos = messageIdString.indexOf(64) + PropsValues.POP_SERVER_SUBDOMAIN.length() + 1;
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            ++pos;
        }
        if ((endPos = messageIdString.indexOf(62, pos)) == -1) {
            endPos = messageIdString.length();
        }
        String mx = messageIdString.substring(pos, endPos);
        return CompanyLocalServiceUtil.getCompanyByMx((String)mx);
    }

    protected long getMessageId(String messageIdString) {
        String[] parts = this.getMessageIdStringParts(messageIdString);
        return GetterUtil.getLong((String)parts[1]);
    }

    protected String getMessageIdString(String recipient, Message message) throws Exception {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            return recipient;
        }
        return MBUtil.getParentMessageIdString(message);
    }

    protected String[] getMessageIdStringParts(String messageIdString) {
        int pos = messageIdString.indexOf(64);
        String target = messageIdString.substring("mb_message.".length() + this.getOffset(), pos);
        return StringUtil.split((String)target, (char)'.');
    }

    protected int getOffset() {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() == 0) {
            return 1;
        }
        return 0;
    }

    protected long getParentMessageId(String recipient, Message message) throws Exception {
        if (!StringUtil.startsWith((String)recipient, (String)"mb_message.")) {
            return MBUtil.getParentMessageId(message);
        }
        int pos = recipient.indexOf(64);
        if (pos < 0) {
            return MBUtil.getParentMessageId(message);
        }
        String target = recipient.substring("mb_message.".length(), pos);
        String[] parts = StringUtil.split((String)target, (char)'.');
        long parentMessageId = 0L;
        if (parts.length == 2) {
            parentMessageId = GetterUtil.getLong((String)parts[1]);
        }
        if (parentMessageId > 0L) {
            return parentMessageId;
        }
        return MBUtil.getParentMessageId(message);
    }

    protected boolean isAutoReply(Message message) throws MessagingException {
        Object[] autoReply = message.getHeader("X-Autoreply");
        if (ArrayUtil.isNotEmpty((Object[])autoReply)) {
            return true;
        }
        Object[] autoReplyFrom = message.getHeader("X-Autoreply-From");
        if (ArrayUtil.isNotEmpty((Object[])autoReplyFrom)) {
            return true;
        }
        Object[] mailAutoReply = message.getHeader("X-Mail-Autoreply");
        return ArrayUtil.isNotEmpty((Object[])mailAutoReply);
    }
}

