/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListTree;
import com.liferay.portal.kernel.util.TreeNode;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryDisplay;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.MBCategoryServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MBCategoryDisplayImpl
implements MBCategoryDisplay {
    private static Log _log = LogFactoryUtil.getLog(MBCategoryDisplayImpl.class);
    private List<MBCategory> _allCategories;
    private Map<Long, TreeNode<MBCategory>> _categoryNodesMap;
    private ListTree<MBCategory> _categoryTree;
    private MBCategory _rootCategory;

    public MBCategoryDisplayImpl(long scopeGroupId, long categoryId) {
        try {
            this.init(scopeGroupId, categoryId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public List<MBCategory> getAllCategories() {
        return this._allCategories;
    }

    public int getAllCategoriesCount() {
        return this._allCategories.size();
    }

    public List<MBCategory> getCategories() {
        return this._categoryTree.getRootNode().getChildValues();
    }

    public List<MBCategory> getCategories(MBCategory category) {
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        return node.getChildValues();
    }

    public MBCategory getRootCategory() {
        return (MBCategory)this._categoryTree.getRootNode().getValue();
    }

    public int getSubcategoriesCount(MBCategory category) {
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        return this._categoryTree.getChildNodes(node).size();
    }

    public int getSubcategoriesMessagesCount(MBCategory category) {
        int count = category.getMessageCount();
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        List childNodes = this._categoryTree.getChildNodes(node);
        for (TreeNode curNode : childNodes) {
            MBCategory curCategory = (MBCategory)curNode.getValue();
            count += curCategory.getMessageCount();
        }
        return count;
    }

    public int getSubcategoriesThreadsCount(MBCategory category) {
        int count = category.getThreadCount();
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        List childNodes = this._categoryTree.getChildNodes(node);
        for (TreeNode curNode : childNodes) {
            MBCategory curCategory = (MBCategory)curNode.getValue();
            count += curCategory.getThreadCount();
        }
        return count;
    }

    public void getSubcategoryIds(MBCategory category, List<Long> categoryIds) {
        List<MBCategory> categories = this.getCategories(category);
        for (MBCategory curCategory : categories) {
            categoryIds.add(curCategory.getCategoryId());
            this.getSubcategoryIds(curCategory, categoryIds);
        }
    }

    protected void init(long scopeGroupId, long categoryId) throws Exception {
        this._allCategories = MBCategoryServiceUtil.getCategories((long)scopeGroupId, (int)0);
        this._rootCategory = new MBCategoryImpl();
        this._rootCategory.setCategoryId(categoryId);
        this._categoryTree = new ListTree((Comparable)this._rootCategory);
        this._categoryNodesMap = new HashMap<Long, TreeNode<MBCategory>>();
        HashMap<Long, List<MBCategory>> categoriesMap = new HashMap<Long, List<MBCategory>>();
        for (MBCategory category : this._allCategories) {
            Long parentCategoryId = category.getParentCategoryId();
            ArrayList<MBCategory> curCategories = (ArrayList<MBCategory>)categoriesMap.get(parentCategoryId);
            if (curCategories == null) {
                curCategories = new ArrayList<MBCategory>();
                categoriesMap.put(parentCategoryId, curCategories);
            }
            curCategories.add(category);
        }
        this.populateCategoryNodesMap((TreeNode<MBCategory>)this._categoryTree.getRootNode(), categoriesMap);
    }

    protected void populateCategoryNodesMap(TreeNode<MBCategory> node, Map<Long, List<MBCategory>> categoriesMap) {
        List<MBCategory> categories;
        MBCategory category = (MBCategory)node.getValue();
        if (category.getCategoryId() == 0L) {
            this._categoryNodesMap.put(category.getCategoryId(), node);
        }
        if ((categories = categoriesMap.get(category.getCategoryId())) == null) {
            return;
        }
        for (MBCategory curCategory : categories) {
            TreeNode curNode = node.addChildNode((Comparable)curCategory);
            this._categoryNodesMap.put(curCategory.getCategoryId(), (TreeNode<MBCategory>)curNode);
            this.populateCategoryNodesMap((TreeNode<MBCategory>)curNode, categoriesMap);
        }
    }
}

