/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.service.RatingsEntryLocalServiceUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MBMessageStagedModelDataHandler
extends BaseStagedModelDataHandler<MBMessage> {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(MBMessageStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        MBMessage message = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (message != null) {
            MBMessageLocalServiceUtil.deleteMessage((MBMessage)message);
        }
    }

    public MBMessage fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List messages = MBMessageLocalServiceUtil.getMBMessagesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)messages)) {
            return null;
        }
        return (MBMessage)messages.get(0);
    }

    public MBMessage fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return MBMessageLocalServiceUtil.fetchMBMessageByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBMessage message) {
        return message.getSubject();
    }

    protected MBMessage addDiscussionMessage(PortletDataContext portletDataContext, long userId, long threadId, long parentMessageId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        MBDiscussion discussion = MBDiscussionLocalServiceUtil.getThreadDiscussion((long)threadId);
        MBMessage importedMessage = null;
        if (!message.isRoot()) {
            importedMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (long)portletDataContext.getScopeGroupId(), (String)discussion.getClassName(), (long)discussion.getClassPK(), (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
        } else {
            MBThread thread = MBThreadLocalServiceUtil.getThread((long)threadId);
            importedMessage = MBMessageLocalServiceUtil.getMBMessage((long)thread.getRootMessageId());
        }
        return importedMessage;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        if (message.isDiscussion()) {
            MBDiscussion discussion = MBDiscussionLocalServiceUtil.getDiscussion((String)message.getClassName(), (long)message.getClassPK());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)discussion, (String)"parent");
            List ratingsEntries = RatingsEntryLocalServiceUtil.getEntries((String)MBDiscussion.class.getName(), (long)message.getMessageId());
            for (RatingsEntry ratingsEntry : ratingsEntries) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)ratingsEntry, (String)"weak");
            }
        } else if (message.getCategoryId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)message.getCategory(), (String)"parent");
        }
        if (!message.isRoot()) {
            MBMessage parentMessage = MBMessageLocalServiceUtil.getMessage((long)message.getParentMessageId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)parentMessage, (String)"parent");
        }
        message.setPriority(message.getPriority());
        MBThread thread = message.getThread();
        Element messageElement = portletDataContext.getExportDataElement((ClassedModel)message);
        messageElement.addAttribute("question", String.valueOf(thread.isQuestion()));
        boolean hasAttachmentsFileEntries = message.getAttachmentsFileEntriesCount() > 0;
        messageElement.addAttribute("hasAttachmentsFileEntries", String.valueOf(hasAttachmentsFileEntries));
        if (hasAttachmentsFileEntries) {
            for (FileEntry fileEntry : message.getAttachmentsFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)fileEntry, (String)"weak");
            }
            long folderId = message.getAttachmentsFolderId();
            if (folderId != 0L) {
                message.setAttachmentsFolderId(folderId);
            }
        }
        portletDataContext.addClassedModel(messageElement, ExportImportPathUtil.getModelPath((StagedModel)message), (ClassedModel)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        long userId = portletDataContext.getUserId(message.getUserUuid());
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)message.getCategoryId(), (long)message.getCategoryId());
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        long threadId = MapUtil.getLong((Map)threadIds, (long)message.getThreadId(), (long)0L);
        Map messageIds = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        long parentMessageId = MapUtil.getLong((Map)messageIds, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)message);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = this.getAttachments(portletDataContext, element, message);
        try {
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)message);
            MBMessage importedMessage = null;
            if (portletDataContext.isDataStrategyMirror()) {
                MBMessage existingMessage = this.fetchStagedModelByUuidAndGroupId(message.getUuid(), portletDataContext.getScopeGroupId());
                if (existingMessage == null) {
                    serviceContext.setUuid(message.getUuid());
                    importedMessage = message.isDiscussion() ? this.addDiscussionMessage(portletDataContext, userId, threadId, parentMessageId, message, serviceContext) : MBMessageLocalServiceUtil.addMessage((long)userId, (String)message.getUserName(), (long)portletDataContext.getScopeGroupId(), (long)parentCategoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                } else if (!message.isRoot() && message.isDiscussion()) {
                    MBDiscussion discussion = MBDiscussionLocalServiceUtil.getThreadDiscussion((long)threadId);
                    importedMessage = MBMessageLocalServiceUtil.updateDiscussionMessage((long)userId, (long)existingMessage.getMessageId(), (String)discussion.getClassName(), (long)discussion.getClassPK(), (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                } else {
                    importedMessage = MBMessageLocalServiceUtil.updateMessage((long)userId, (long)existingMessage.getMessageId(), (String)message.getSubject(), (String)message.getBody(), inputStreamOVPs, new ArrayList(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                }
            } else {
                importedMessage = message.isDiscussion() ? this.addDiscussionMessage(portletDataContext, userId, threadId, parentMessageId, message, serviceContext) : MBMessageLocalServiceUtil.addMessage((long)userId, (String)message.getUserName(), (long)portletDataContext.getScopeGroupId(), (long)parentCategoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
            }
            MBMessageLocalServiceUtil.updateAnswer((MBMessage)importedMessage, (boolean)message.isAnswer(), (boolean)false);
            if (importedMessage.isRoot() && !importedMessage.isDiscussion()) {
                MBThreadLocalServiceUtil.updateQuestion((long)importedMessage.getThreadId(), (boolean)GetterUtil.getBoolean((String)element.attributeValue("question")));
            }
            if (message.isDiscussion()) {
                Map discussionIds = portletDataContext.getNewPrimaryKeysMap(MBDiscussion.class);
                discussionIds.put(message.getMessageId(), importedMessage.getMessageId());
            }
            threadIds.put(message.getThreadId(), importedMessage.getThreadId());
            portletDataContext.importClassedModel((ClassedModel)message, (ClassedModel)importedMessage);
        }
        catch (Throwable throwable) {
            for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
                InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            throw throwable;
        }
        for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        MBThread existingThread;
        TrashHandler trashHandler;
        TrashHandler trashHandler2;
        long userId = portletDataContext.getUserId(message.getUserUuid());
        MBMessage existingMessage = this.fetchStagedModelByUuidAndGroupId(message.getUuid(), portletDataContext.getScopeGroupId());
        if (existingMessage == null) {
            return;
        }
        if (existingMessage.isInTrash() && (trashHandler2 = existingMessage.getTrashHandler()).isRestorable(existingMessage.getMessageId())) {
            trashHandler2.restoreTrashEntry(userId, existingMessage.getMessageId());
        }
        if (existingMessage.isInTrashContainer() && (trashHandler = (existingThread = existingMessage.getThread()).getTrashHandler()).isRestorable(existingThread.getThreadId())) {
            trashHandler.restoreTrashEntry(userId, existingThread.getThreadId());
        }
    }

    protected List<ObjectValuePair<String, InputStream>> getAttachments(PortletDataContext portletDataContext, Element messageElement, MBMessage message) {
        boolean hasAttachmentsFileEntries = GetterUtil.getBoolean((String)messageElement.attributeValue("hasAttachmentsFileEntries"));
        if (!hasAttachmentsFileEntries) {
            return Collections.emptyList();
        }
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        List attachmentElements = portletDataContext.getReferenceDataElements(messageElement, DLFileEntry.class, "weak");
        for (Element attachmentElement : attachmentElements) {
            String path = attachmentElement.attributeValue("path");
            FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
            InputStream inputStream = null;
            String binPath = attachmentElement.attributeValue("bin-path");
            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                try {
                    inputStream = FileEntryUtil.getContentStream(fileEntry);
                }
                catch (Exception e) {}
            } else {
                inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
            }
            if (inputStream == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                continue;
            }
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileEntry.getTitle(), (Object)inputStream);
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        if (inputStreamOVPs.isEmpty()) {
            _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
        }
        return inputStreamOVPs;
    }
}

