/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class MBDiscussionStagedModelDataHandler
extends BaseStagedModelDataHandler<MBDiscussion> {
    public static final String[] CLASS_NAMES = new String[]{MBDiscussion.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MBDiscussion discussion = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (discussion != null) {
            MBDiscussionLocalServiceUtil.deleteMBDiscussion((MBDiscussion)discussion);
        }
    }

    public MBDiscussion fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List discussions = MBDiscussionLocalServiceUtil.getMBDiscussionsByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)discussions)) {
            return null;
        }
        return (MBDiscussion)discussions.get(0);
    }

    public MBDiscussion fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return MBDiscussionLocalServiceUtil.fetchMBDiscussionByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBDiscussion discussion) {
        try {
            AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)discussion.getClassName(), (long)discussion.getClassPK());
            return assetEntry.getTitleCurrentValue();
        }
        catch (Exception e) {
            return discussion.getUuid();
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBDiscussion discussion) throws Exception {
        Element discussionElement = portletDataContext.getExportDataElement((ClassedModel)discussion);
        portletDataContext.addClassedModel(discussionElement, ExportImportPathUtil.getModelPath((StagedModel)discussion), (ClassedModel)discussion);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBDiscussion discussion) throws Exception {
        long userId = portletDataContext.getUserId(discussion.getUserUuid());
        String className = discussion.getClassName();
        Map relatedClassPKs = portletDataContext.getNewPrimaryKeysMap(className);
        long newClassPK = MapUtil.getLong((Map)relatedClassPKs, (long)discussion.getClassPK(), (long)discussion.getClassPK());
        MBDiscussion existingDiscussion = MBDiscussionLocalServiceUtil.fetchDiscussion((String)discussion.getClassName(), (long)newClassPK);
        if (existingDiscussion == null && className.equals(Layout.class.getName()) && PropsValues.LAYOUT_COMMENTS_ENABLED) {
            MBMessage rootMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)discussion.getUserName(), (long)portletDataContext.getScopeGroupId(), (String)Layout.class.getName(), (long)newClassPK, (int)1);
            existingDiscussion = MBDiscussionLocalServiceUtil.getThreadDiscussion((long)rootMessage.getThreadId());
        }
        Map discussionIds = portletDataContext.getNewPrimaryKeysMap(MBDiscussion.class);
        discussionIds.put(discussion.getDiscussionId(), existingDiscussion.getDiscussionId());
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        threadIds.put(discussion.getThreadId(), existingDiscussion.getThreadId());
    }
}

