/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class MBCategoryStagedModelDataHandler
extends BaseStagedModelDataHandler<MBCategory> {
    public static final String[] CLASS_NAMES = new String[]{MBCategory.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        MBCategory category = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (category != null) {
            MBCategoryLocalServiceUtil.deleteCategory((MBCategory)category);
        }
    }

    public MBCategory fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List categories = MBCategoryLocalServiceUtil.getMBCategoriesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)categories)) {
            return null;
        }
        return (MBCategory)categories.get(0);
    }

    public MBCategory fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return MBCategoryLocalServiceUtil.fetchMBCategoryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBCategory category) {
        return category.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        if (category.getCategoryId() == 0L || category.getCategoryId() == -1L) {
            return;
        }
        if (category.getParentCategory() != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)category, (StagedModel)category.getParentCategory(), (String)"parent");
        }
        Element categoryElement = portletDataContext.getExportDataElement((ClassedModel)category);
        portletDataContext.addClassedModel(categoryElement, ExportImportPathUtil.getModelPath((StagedModel)category), (ClassedModel)category);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        long userId = portletDataContext.getUserId(category.getUserUuid());
        String emailAddress = null;
        String inProtocol = null;
        String inServerName = null;
        int inServerPort = 0;
        boolean inUseSSL = false;
        String inUserName = null;
        String inPassword = null;
        int inReadInterval = 0;
        String outEmailAddress = null;
        boolean outCustom = false;
        String outServerName = null;
        int outServerPort = 0;
        boolean outUseSSL = false;
        String outUserName = null;
        String outPassword = null;
        boolean allowAnonymous = false;
        boolean mailingListActive = false;
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)category);
        MBCategory importedCategory = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MBCategory existingCategory = this.fetchStagedModelByUuidAndGroupId(category.getUuid(), portletDataContext.getScopeGroupId());
            if (existingCategory == null) {
                serviceContext.setUuid(category.getUuid());
                importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
            } else {
                importedCategory = MBCategoryLocalServiceUtil.updateCategory((long)existingCategory.getCategoryId(), (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)category, (ClassedModel)importedCategory);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        long userId = portletDataContext.getUserId(category.getUserUuid());
        MBCategory existingCategory = this.fetchStagedModelByUuidAndGroupId(category.getUuid(), portletDataContext.getScopeGroupId());
        if (existingCategory == null || !existingCategory.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingCategory.getTrashHandler();
        if (trashHandler.isRestorable(existingCategory.getCategoryId())) {
            trashHandler.restoreTrashEntry(userId, existingCategory.getCategoryId());
        }
    }
}

