/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import java.util.List;

public class MBBanStagedModelDataHandler
extends BaseStagedModelDataHandler<MBBan> {
    public static final String[] CLASS_NAMES = new String[]{MBBan.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(MBBanStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MBBan ban = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ban != null) {
            MBBanLocalServiceUtil.deleteBan((MBBan)ban);
        }
    }

    public MBBan fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List bans = MBBanLocalServiceUtil.getMBBansByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)bans)) {
            return null;
        }
        return (MBBan)bans.get(0);
    }

    public MBBan fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return MBBanLocalServiceUtil.fetchMBBanByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBBan ban) throws Exception {
        Element userBanElement = portletDataContext.getExportDataElement((ClassedModel)ban);
        ban.setBanUserUuid(ban.getBanUserUuid());
        User bannedUser = UserLocalServiceUtil.getUser((long)ban.getUserId());
        portletDataContext.addReferenceElement((ClassedModel)ban, userBanElement, (ClassedModel)bannedUser, "disposable_dependency", true);
        portletDataContext.addClassedModel(userBanElement, ExportImportPathUtil.getModelPath((StagedModel)ban), (ClassedModel)ban);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBBan ban) throws Exception {
        User user = UserLocalServiceUtil.fetchUserByUuidAndCompanyId((String)ban.getBanUserUuid(), (long)portletDataContext.getCompanyId());
        if (user == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find banned user with uuid " + ban.getBanUserUuid()));
            }
            return;
        }
        long userId = portletDataContext.getUserId(ban.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ban);
        serviceContext.setUuid(ban.getUuid());
        MBBanLocalServiceUtil.addBan((long)userId, (long)user.getUserId(), (ServiceContext)serviceContext);
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, MBBan ban) {
    }
}

