/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.comment;

import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalService;
import java.util.List;

public class MBCommentManagerImpl
implements CommentManager {
    private MBMessageLocalService _mbMessageLocalService;

    public void addComment(long userId, long groupId, String className, long classPK, String body, ServiceContext serviceContext) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread thread = messageDisplay.getThread();
        List messages = this._mbMessageLocalService.getThreadMessages(thread.getThreadId(), 0);
        for (MBMessage message : messages) {
            String messageBody = message.getBody();
            if (!messageBody.equals(body)) continue;
            throw new DuplicateCommentException();
        }
        this._mbMessageLocalService.addDiscussionMessage(userId, "", groupId, className, classPK, thread.getThreadId(), thread.getRootMessageId(), "", body, serviceContext);
    }

    public long addComment(long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay mbMessageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread mbThread = mbMessageDisplay.getThread();
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, mbThread.getThreadId(), mbThread.getRootMessageId(), subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, 1);
    }

    public void deleteComment(long commentId) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessage(commentId);
    }

    public void deleteDiscussion(String className, long classPK) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessages(className, classPK);
    }

    public int getCommentsCount(String className, long classPK) {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this._mbMessageLocalService.getDiscussionMessagesCount(classNameId, classPK, 0);
    }

    public void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }
}

