/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.messageboards.asset.MBMessageAssetRenderer;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class MBMessageAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "message";

    public MBMessageAssetRendererFactory() {
        this.setCategorizable(false);
        this.setLinkable(true);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
        MBMessageAssetRenderer mbMessageAssetRenderer = new MBMessageAssetRenderer(message);
        mbMessageAssetRenderer.setAssetRendererType(type);
        return mbMessageAssetRenderer;
    }

    public String getClassName() {
        return MBMessage.class.getName();
    }

    public String getIconCssClass() {
        return "icon-comments";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("19", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return MBMessagePermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/conversation.png";
    }
}

