/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.messageboards.asset.MBCategoryAssetRenderer;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class MBCategoryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "category";

    public MBCategoryAssetRendererFactory() {
        this.setCategorizable(false);
        this.setSelectable(false);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        MBCategory category = MBCategoryLocalServiceUtil.getMBCategory((long)classPK);
        MBCategoryAssetRenderer mbCategoryAssetRenderer = new MBCategoryAssetRenderer(category);
        mbCategoryAssetRenderer.setAssetRendererType(type);
        return mbCategoryAssetRenderer;
    }

    public String getClassName() {
        return MBCategory.class.getName();
    }

    public String getIconCssClass() {
        return "icon-comments";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("19", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        MBCategory category = MBCategoryLocalServiceUtil.getMBCategory((long)classPK);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/conversation.png";
    }
}

