/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewMessageAction
extends PortletAction {
    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            MBMessage message;
            boolean includePrevAndNext;
            MBMessageDisplay messageDisplay;
            long messageId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"messageId");
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            int status = 0;
            if (permissionChecker.isContentReviewer(themeDisplay.getUserId(), themeDisplay.getScopeGroupId())) {
                status = -1;
            }
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)renderRequest);
            String threadView = ParamUtil.getString((PortletRequest)renderRequest, (String)"threadView");
            if (Validator.isNotNull((String)threadView)) {
                preferences.setValue("19", "thread-view", threadView);
            } else {
                threadView = preferences.getValue("19", "thread-view", PropsValues.MESSAGE_BOARDS_THREAD_VIEWS_DEFAULT);
            }
            if (!ArrayUtil.contains((Object[])PropsValues.MESSAGE_BOARDS_THREAD_VIEWS, (Object)threadView)) {
                threadView = PropsValues.MESSAGE_BOARDS_THREAD_VIEWS_DEFAULT;
                preferences.setValue("19", "thread-view", threadView);
            }
            if ((messageDisplay = MBMessageServiceUtil.getMessageDisplay((long)messageId, (int)status, (String)threadView, (boolean)(includePrevAndNext = PropsValues.MESSAGE_BOARDS_THREAD_PREVIOUS_AND_NEXT_NAVIGATION_ENABLED))) != null && (message = messageDisplay.getMessage()) != null && message.isInTrash()) {
                throw new NoSuchMessageException("{messageId=" + messageId + "}");
            }
            renderRequest.setAttribute("MESSAGE_BOARDS_MESSAGE", (Object)messageDisplay);
            return actionMapping.findForward("portlet.message_boards.view_message");
        }
        catch (Exception e) {
            if (e instanceof NoSuchMessageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.message_boards.error");
            }
            throw e;
        }
    }
}

