/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.captcha.CaptchaMaxChallengesException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.MBSettings;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditMessageAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        MBMessage message = null;
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException();
                }
                if (uploadException.isExceededSizeLimit()) {
                    throw new FileSizeException(uploadException.getCause());
                }
                throw new PortalException(uploadException.getCause());
            }
            if (cmd.equals("add") || cmd.equals("update")) {
                message = this.updateMessage(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteMessage(actionRequest);
            } else if (cmd.equals("lock")) {
                this.lockThreads(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeMessage(actionRequest);
            } else if (cmd.equals("unlock")) {
                this.unlockThreads(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeMessage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    String redirect = this.getRedirect(actionRequest, actionResponse, message);
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else {
                    String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchMessageException || e instanceof PrincipalException || e instanceof RequiredMessageException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e instanceof AntivirusScannerException || e instanceof CaptchaMaxChallengesException || e instanceof CaptchaTextException || e instanceof DuplicateFileException || e instanceof FileExtensionException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof LiferayFileItemException || e instanceof LockedThreadException || e instanceof MessageBodyException || e instanceof MessageSubjectException || e instanceof SanitizerException) {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    String uploadExceptionRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadExceptionRedirect");
                    actionResponse.sendRedirect(uploadExceptionRedirect);
                }
                if (e instanceof AntivirusScannerException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            Throwable cause = e.getCause();
            if (cause instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, SanitizerException.class);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchMessageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.message_boards.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.edit_message"));
    }

    protected void deleteMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.deleteMessage((long)messageId);
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        if (message == null) {
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            return redirect;
        }
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
        if (workflowAction == 2) {
            return this.getSaveAndContinueRedirect(actionRequest, actionResponse, message);
        }
        if (message == null) {
            return ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        }
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletURL portletURL = actionResponseImpl.createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        return portletURL.toString();
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/edit_message");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        portletURL.setParameter("preview", String.valueOf(preview));
        return portletURL.toString();
    }

    protected void lockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            MBThreadServiceUtil.lockThread((long)threadId);
        } else {
            long[] threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
            for (int i = 0; i < threadIds.length; ++i) {
                MBThreadServiceUtil.lockThread((long)threadIds[i]);
            }
        }
    }

    protected void subscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.subscribeMessage((long)messageId);
    }

    protected void unlockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            MBThreadServiceUtil.unlockThread((long)threadId);
        } else {
            long[] threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
            for (int i = 0; i < threadIds.length; ++i) {
                MBThreadServiceUtil.unlockThread((long)threadIds[i]);
            }
        }
    }

    protected void unsubscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.unsubscribeMessage((long)messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBMessage updateMessage(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        MBMessage mBMessage;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        long groupId = themeDisplay.getScopeGroupId();
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        long parentMessageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMessageId");
        String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
        String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
        MBSettings mbSettings = MBSettings.getInstance(groupId);
        ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>(5);
        try {
            UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            for (int i = 1; i <= 5; ++i) {
                String fileName = uploadPortletRequest.getFileName("msgFile" + i);
                InputStream inputStream = uploadPortletRequest.getFileAsStream("msgFile" + i);
                if (inputStream == null || Validator.isNull((String)fileName)) continue;
                ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                inputStreamOVPs.add(inputStreamOVP);
            }
            boolean question = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"question");
            boolean anonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"anonymous");
            double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
            boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
            boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
            serviceContext.setAttribute("preview", (Serializable)Boolean.valueOf(preview));
            MBMessage message = null;
            if (messageId <= 0L) {
                if (PropsValues.CAPTCHA_CHECK_PORTLET_MESSAGE_BOARDS_EDIT_MESSAGE) {
                    CaptchaUtil.check((PortletRequest)actionRequest);
                }
                if (threadId <= 0L) {
                    message = MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)body, (String)mbSettings.getMessageFormat(), inputStreamOVPs, (boolean)anonymous, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                    if (question) {
                        MBThreadLocalServiceUtil.updateQuestion((long)message.getThreadId(), (boolean)true);
                    }
                } else {
                    message = MBMessageServiceUtil.addMessage((long)parentMessageId, (String)subject, (String)body, (String)mbSettings.getMessageFormat(), inputStreamOVPs, (boolean)anonymous, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                }
            } else {
                ArrayList<String> existingFiles = new ArrayList<String>();
                for (int i = 1; i <= 5; ++i) {
                    String path = ParamUtil.getString((PortletRequest)actionRequest, (String)("existingPath" + i));
                    if (!Validator.isNotNull((String)path)) continue;
                    existingFiles.add(path);
                }
                message = MBMessageServiceUtil.updateMessage((long)messageId, (String)subject, (String)body, inputStreamOVPs, existingFiles, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                if (message.isRoot()) {
                    MBThreadLocalServiceUtil.updateQuestion((long)message.getThreadId(), (boolean)question);
                }
            }
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            boolean subscribe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"subscribe");
            if (!preview && subscribe && MBMessagePermission.contains(permissionChecker, message, "SUBSCRIBE")) {
                MBMessageServiceUtil.subscribeMessage((long)message.getMessageId());
            }
            mBMessage = message;
        }
        catch (Throwable throwable) {
            for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
                InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            throw throwable;
        }
        for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        return mBMessage;
    }
}

