/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class DeleteThreadAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteThreads(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteThreads(actionRequest, true);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof LockedThreadException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            throw e;
        }
    }

    protected void deleteThreads(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteThreadIds = null;
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        deleteThreadIds = threadId > 0L ? new long[]{threadId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
        ArrayList<MBThread> trashedModels = new ArrayList<MBThread>();
        for (long deleteThreadId : deleteThreadIds) {
            if (moveToTrash) {
                MBThread thread = MBThreadServiceUtil.moveThreadToTrash((long)deleteThreadId);
                trashedModels.add(thread);
                continue;
            }
            MBThreadServiceUtil.deleteThread((long)deleteThreadId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }
}

