/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.util.RSSUtil;
import java.util.Map;

public class MBSettings {
    public static final String[] ALL_KEYS = new String[]{"emailFromAddress", "emailFromName", "emailMessageAddedBody", "emailMessageAddedSubject", "emailMessageUpdatedBody", "emailMessageUpdatedSubject", "messageFormat", "priorities", "ranks", "recentPostsDateOffset", "rssDelta", "rssDisplayStyle", "rssFeedType", "allowAnonymousPosting", "emailHtmlFormat", "emailMessageAddedEnabled", "emailMessageUpdatedEnabled", "enableFlags", "enableRatings", "enableRss", "subscribeByDefault", "threadAsQuestionByDefault"};
    private static final String[] _MULTI_VALUED_KEYS = new String[]{"ranks"};
    private TypedSettings _typedSettings;

    public static MBSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.messageboards");
        return new MBSettings(settings);
    }

    public static MBSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.messageboards");
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new MBSettings((Settings)parameterMapSettings);
    }

    public MBSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public LocalizedValuesMap getEmailMessageAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageAddedBody");
    }

    public String getEmailMessageAddedBodyXml() {
        LocalizedValuesMap emailMessageBodyMap = this.getEmailMessageAddedBody();
        return emailMessageBodyMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailMessageAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageAddedSubject");
    }

    public String getEmailMessageAddedSubjectXml() {
        LocalizedValuesMap emailMessageAddedSubjectMap = this.getEmailMessageAddedSubject();
        return emailMessageAddedSubjectMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailMessageUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageUpdatedBody");
    }

    public String getEmailMessageUpdatedBodyXml() {
        LocalizedValuesMap emailMessageUpdatedBodyMap = this.getEmailMessageUpdatedBody();
        return emailMessageUpdatedBodyMap.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailMessageUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageUpdatedSubject");
    }

    public String getEmailMessageUpdatedSubjectXml() {
        LocalizedValuesMap emailMessageUpdatedSubjectMap = this.getEmailMessageUpdatedSubject();
        return emailMessageUpdatedSubjectMap.getLocalizationXml();
    }

    public String getMessageFormat() {
        String messageFormat = this._typedSettings.getValue("messageFormat");
        if (MBUtil.isValidMessageFormat(messageFormat)) {
            return messageFormat;
        }
        return "html";
    }

    public String[] getPriorities(String currentLanguageId) {
        return LocalizationUtil.getSettingsValues((Settings)this._typedSettings.getWrappedSettings(), (String)"priorities", (String)currentLanguageId);
    }

    public String[] getRanks(String languageId) {
        return LocalizationUtil.getSettingsValues((Settings)this._typedSettings.getWrappedSettings(), (String)"ranks", (String)languageId);
    }

    public String getRecentPostsDateOffset() {
        return this._typedSettings.getValue("recentPostsDateOffset");
    }

    public int getRSSDelta() {
        return this._typedSettings.getIntegerValue("rssDelta");
    }

    public String getRSSDisplayStyle() {
        return this._typedSettings.getValue("rssDisplayStyle", "full-content");
    }

    public String getRSSFeedType() {
        return this._typedSettings.getValue("rssFeedType", RSSUtil.getFeedType((String)"atom", (double)1.0));
    }

    public boolean isAllowAnonymousPosting() {
        return this._typedSettings.getBooleanValue("allowAnonymousPosting");
    }

    public boolean isEmailHtmlFormat() {
        return this._typedSettings.getBooleanValue("emailHtmlFormat");
    }

    public boolean isEmailMessageAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailMessageAddedEnabled");
    }

    public boolean isEmailMessageUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailMessageUpdatedEnabled");
    }

    public boolean isEnableFlags() {
        return this._typedSettings.getBooleanValue("enableFlags");
    }

    public boolean isEnableRatings() {
        return this._typedSettings.getBooleanValue("enableRatings");
    }

    public boolean isEnableRSS() {
        if (!PortalUtil.isRSSFeedsEnabled()) {
            return false;
        }
        return this._typedSettings.getBooleanValue("enableRss");
    }

    public boolean isSubscribeByDefault() {
        return this._typedSettings.getBooleanValue("subscribeByDefault");
    }

    public boolean isThreadAsQuestionByDefault() {
        return this._typedSettings.getBooleanValue("threadAsQuestionByDefault");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("allowAnonymousPosting", new String[]{"message.boards.anonymous.posting.enabled"});
        fallbackKeys.add("emailFromAddress", new String[]{"message.boards.email.from.address", "admin.email.from.address"});
        fallbackKeys.add("emailFromName", new String[]{"message.boards.email.from.name", "admin.email.from.name"});
        fallbackKeys.add("emailHtmlFormat", new String[]{"message.boards.email.html.format"});
        fallbackKeys.add("emailMessageAddedBody", new String[]{"message.boards.email.message.added.body"});
        fallbackKeys.add("emailMessageAddedEnabled", new String[]{"message.boards.email.message.added.enabled"});
        fallbackKeys.add("emailMessageAddedSubject", new String[]{"message.boards.email.message.added.subject"});
        fallbackKeys.add("emailMessageUpdatedBody", new String[]{"message.boards.email.message.updated.body"});
        fallbackKeys.add("emailMessageUpdatedEnabled", new String[]{"message.boards.email.message.updated.enabled"});
        fallbackKeys.add("emailMessageUpdatedSubject", new String[]{"message.boards.email.message.updated.subject"});
        fallbackKeys.add("enableFlags", new String[]{"message.boards.flags.enabled"});
        fallbackKeys.add("enableRatings", new String[]{"message.boards.ratings.enabled"});
        fallbackKeys.add("enableRss", new String[]{"message.boards.rss.enabled"});
        fallbackKeys.add("messageFormat", new String[]{"message.boards.message.formats.default"});
        fallbackKeys.add("priorities", new String[]{"message.boards.thread.priorities"});
        fallbackKeys.add("ranks", new String[]{"message.boards.user.ranks"});
        fallbackKeys.add("recentPostsDateOffset", new String[]{"message.boards.recent.posts.date.offset"});
        fallbackKeys.add("rssDelta", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("rssDisplayStyle", new String[]{"rss.feed.display.style.default"});
        fallbackKeys.add("rssFeedType", new String[]{"rss.feed.type.default"});
        fallbackKeys.add("subscribeByDefault", new String[]{"message.boards.subscribe.by.default"});
        fallbackKeys.add("threadAsQuestionByDefault", new String[]{"message.boards.thread.as.question.by.default"});
        return fallbackKeys;
    }

    static {
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("com.liferay.portlet.messageboards", MBSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

