/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SessionClicks;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LayoutsTreeUtil {
    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId) throws Exception {
        return LayoutsTreeUtil.getLayoutsJSON(request, groupId, privateLayout, parentLayoutId, null, incomplete, treeId);
    }

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete, String treeId) throws Exception {
        LayoutTreeNodes layoutTreeNodes = LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, privateLayout, parentLayoutId, incomplete, expandedLayoutIds, treeId);
        return LayoutsTreeUtil._toJSON(request, groupId, layoutTreeNodes);
    }

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, String treeId) throws Exception {
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes();
        layoutTreeNodes.addAll(LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, true, 0L, false, null, treeId));
        layoutTreeNodes.addAll(LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, false, 0L, false, null, treeId));
        return LayoutsTreeUtil._toJSON(request, groupId, layoutTreeNodes);
    }

    private static List<Layout> _getAncestorLayouts(HttpServletRequest request) throws Exception {
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid");
        if (selPlid == 0L) {
            return Collections.emptyList();
        }
        List ancestorLayouts = LayoutServiceUtil.getAncestorLayouts((long)selPlid);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)selPlid);
        ancestorLayouts.add(layout);
        return ancestorLayouts;
    }

    private static LayoutTreeNodes _getLayoutTreeNodes(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, long[] expandedLayoutIds, String treeId) throws Exception {
        ArrayList<LayoutTreeNode> layoutTreeNodes = new ArrayList<LayoutTreeNode>();
        List<Layout> ancestorLayouts = LayoutsTreeUtil._getAncestorLayouts(request);
        List layouts = LayoutServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (boolean)incomplete, (int)-1, (int)-1);
        for (Layout layout : LayoutsTreeUtil._paginateLayouts(request, groupId, privateLayout, parentLayoutId, layouts, treeId)) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            LayoutTreeNodes childLayoutTreeNodes = null;
            if (LayoutsTreeUtil._isExpandableLayout(request, ancestorLayouts, expandedLayoutIds, layout)) {
                if (layout instanceof VirtualLayout) {
                    VirtualLayout virtualLayout = (VirtualLayout)layout;
                    childLayoutTreeNodes = LayoutsTreeUtil._getLayoutTreeNodes(request, virtualLayout.getSourceGroupId(), virtualLayout.isPrivateLayout(), virtualLayout.getLayoutId(), incomplete, expandedLayoutIds, treeId);
                } else {
                    childLayoutTreeNodes = LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, layout.isPrivateLayout(), layout.getLayoutId(), incomplete, expandedLayoutIds, treeId);
                }
            } else {
                int childLayoutsCount = LayoutServiceUtil.getLayoutsCount((long)groupId, (boolean)privateLayout, (long)layout.getLayoutId());
                childLayoutTreeNodes = new LayoutTreeNodes(new ArrayList<LayoutTreeNode>(), childLayoutsCount);
            }
            layoutTreeNode.setChildLayoutTreeNodes(childLayoutTreeNodes);
            layoutTreeNodes.add(layoutTreeNode);
        }
        return new LayoutTreeNodes(layoutTreeNodes, layouts.size());
    }

    private static int _getLoadedLayoutsCount(HttpSession session, long groupId, boolean privateLayout, long layoutId, String treeId) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append(treeId);
        sb.append(":");
        sb.append(groupId);
        sb.append(":");
        sb.append(privateLayout);
        sb.append(":");
        sb.append("Pagination");
        String paginationJSON = SessionClicks.get((HttpSession)session, (String)sb.toString(), (String)JSONFactoryUtil.getNullJSON());
        JSONObject paginationJSONObject = JSONFactoryUtil.createJSONObject((String)paginationJSON);
        return paginationJSONObject.getInt(String.valueOf(layoutId), 0);
    }

    private static boolean _isExpandableLayout(HttpServletRequest request, List<Layout> ancestorLayouts, long[] expandedLayoutIds, Layout layout) {
        boolean expandParentLayouts = ParamUtil.getBoolean((HttpServletRequest)request, (String)"expandParentLayouts");
        return expandParentLayouts || ancestorLayouts.contains(layout) || ArrayUtil.contains((long[])expandedLayoutIds, (long)layout.getLayoutId());
    }

    private static boolean _isPaginationEnabled(HttpServletRequest request) {
        boolean paginate = ParamUtil.getBoolean((HttpServletRequest)request, (String)"paginate", (boolean)true);
        return paginate && PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN > -1;
    }

    private static List<Layout> _paginateLayouts(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, List<Layout> layouts, String treeId) throws Exception {
        if (!LayoutsTreeUtil._isPaginationEnabled(request)) {
            return layouts;
        }
        HttpSession session = request.getSession();
        int loadedLayoutsCount = LayoutsTreeUtil._getLoadedLayoutsCount(session, groupId, privateLayout, parentLayoutId, treeId);
        int start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start");
        int end = ParamUtil.getInteger((HttpServletRequest)request, (String)"end", (int)((start = Math.max(0, Math.min(start, layouts.size()))) + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN));
        if (loadedLayoutsCount > end) {
            end = loadedLayoutsCount;
        }
        end = Math.max(start, Math.min(end, layouts.size()));
        return layouts.subList(start, end);
    }

    private static String _toJSON(HttpServletRequest request, long groupId, LayoutTreeNodes layoutTreeNodes) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        boolean hasManageLayoutsPermission = GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        for (LayoutTreeNode layoutTreeNode : layoutTreeNodes) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            String childrenJSON = LayoutsTreeUtil._toJSON(request, groupId, layoutTreeNode.getChildLayoutTreeNodes());
            jsonObject.put("children", JSONFactoryUtil.createJSONObject((String)childrenJSON));
            Layout layout = layoutTreeNode.getLayout();
            jsonObject.put("contentDisplayPage", layout.isContentDisplayPage());
            jsonObject.put("friendlyURL", layout.getFriendlyURL());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                jsonObject.put("groupId", virtualLayout.getSourceGroupId());
            } else {
                jsonObject.put("groupId", layout.getGroupId());
            }
            jsonObject.put("hasChildren", layout.hasChildren());
            jsonObject.put("layoutId", layout.getLayoutId());
            jsonObject.put("name", layout.getName(themeDisplay.getLocale()));
            LayoutType layoutType = layout.getLayoutType();
            jsonObject.put("parentable", layoutType.isParentable());
            jsonObject.put("parentLayoutId", layout.getParentLayoutId());
            jsonObject.put("plid", layout.getPlid());
            jsonObject.put("priority", layout.getPriority());
            jsonObject.put("privateLayout", layout.isPrivateLayout());
            jsonObject.put("sortable", hasManageLayoutsPermission && SitesUtil.isLayoutSortable((Layout)layout));
            jsonObject.put("type", layout.getType());
            jsonObject.put("updateable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE"));
            jsonObject.put("uuid", layout.getUuid());
            LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
            if (layoutRevision != null) {
                User user = themeDisplay.getUser();
                long recentLayoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layout.getLayoutSet().getLayoutSetId());
                if (StagingUtil.isIncomplete((Layout)layout, (long)recentLayoutSetBranchId)) {
                    jsonObject.put("incomplete", true);
                }
                long layoutSetBranchId = layoutRevision.getLayoutSetBranchId();
                LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
                LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
                if (!layoutBranch.isMaster()) {
                    jsonObject.put("layoutBranchId", layoutBranch.getLayoutBranchId());
                    jsonObject.put("layoutBranchName", layoutBranch.getName());
                }
                if (layoutRevision.isHead()) {
                    jsonObject.put("layoutRevisionHead", true);
                }
                jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId());
                jsonObject.put("layoutSetBranchId", layoutSetBranchId);
                jsonObject.put("layoutSetBranchName", layoutSetBranch.getName());
            }
            jsonArray.put(jsonObject);
        }
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject();
        responseJSONObject.put("layouts", jsonArray);
        responseJSONObject.put("total", layoutTreeNodes.getTotal());
        return responseJSONObject.toString();
    }

    private static class LayoutTreeNodes
    implements Iterable<LayoutTreeNode> {
        private List<LayoutTreeNode> _layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        private int _total;

        public LayoutTreeNodes() {
        }

        public LayoutTreeNodes(List<LayoutTreeNode> layoutTreeNodesList, int total) {
            this._layoutTreeNodesList = layoutTreeNodesList;
            this._total = total;
        }

        public void addAll(LayoutTreeNodes layoutTreeNodes) {
            this._layoutTreeNodesList.addAll(layoutTreeNodes.getLayoutTreeNodesList());
            this._total += layoutTreeNodes.getTotal();
        }

        public List<LayoutTreeNode> getLayoutTreeNodesList() {
            return this._layoutTreeNodesList;
        }

        public int getTotal() {
            return this._total;
        }

        @Override
        public Iterator<LayoutTreeNode> iterator() {
            return this._layoutTreeNodesList.iterator();
        }
    }

    private static class LayoutTreeNode {
        private LayoutTreeNodes _childLayoutTreeNodes = new LayoutTreeNodes();
        private Layout _layout;

        public LayoutTreeNode(Layout layout) {
            this._layout = layout;
        }

        public LayoutTreeNodes getChildLayoutTreeNodes() {
            return this._childLayoutTreeNodes;
        }

        public Layout getLayout() {
            return this._layout;
        }

        public void setChildLayoutTreeNodes(LayoutTreeNodes childLayoutTreeNodes) {
            this._childLayoutTreeNodes = childLayoutTreeNodes;
        }
    }
}

