/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.service.ExportImportConfigurationLocalServiceUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class ExportImportConfigurationIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{ExportImportConfiguration.class.getName()};
    public static final String PORTLET_ID = "88";
    private static final String _PREFIX_PARAMETER = "parameter_";
    private static final String _PREFIX_SETTING = "setting_";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    protected void doDelete(Object obj) throws Exception {
        ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)obj;
        this.deleteDocument(exportImportConfiguration.getCompanyId(), exportImportConfiguration.getExportImportConfigurationId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)exportImportConfiguration);
        document.addText("description", exportImportConfiguration.getDescription());
        document.addText("name", exportImportConfiguration.getName());
        document.addKeyword("type", exportImportConfiguration.getType());
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        this.populateDates(document, settingsMap);
        this.populateLayoutIds(document, settingsMap);
        this.populateLocale(document, settingsMap);
        this.populateParameterMap(document, settingsMap);
        this.populateSiteInformation(document, settingsMap);
        this.populateTimeZone(document, settingsMap);
        document.addKeyword("setting_userId", MapUtil.getLong((Map)settingsMap, (String)"userId"));
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        String exportImportConfigurationId = document.get("entryClassPK");
        Summary summary = this.createSummary(document, "title", "description");
        portletURL.setParameter("struts_action", "/layouts_admin/edit_export_configuration");
        portletURL.setParameter("exportImportConfigurationId", exportImportConfigurationId);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)obj;
        Document document = this.getDocument(exportImportConfiguration);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)exportImportConfiguration.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)classPK);
        this.doReindex(exportImportConfiguration);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexExportImportConfigurations(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void populateDates(Document document, Map<String, Serializable> settingsMap) {
        if (settingsMap.containsKey("endDate")) {
            Date endDate = (Date)settingsMap.get("endDate");
            document.addDate("setting_endDate", endDate);
        }
        if (settingsMap.containsKey("startDate")) {
            Date startDate = (Date)settingsMap.get("startDate");
            document.addDate("setting_startDate", startDate);
        }
    }

    protected void populateLayoutIds(Document document, Map<String, Serializable> settingsMap) {
        if (!settingsMap.containsKey("layoutIdMap")) {
            return;
        }
        Map layoutIdMap = (Map)((Object)settingsMap.get("layoutIdMap"));
        Set layoutIdSet = layoutIdMap.keySet();
        Long[] layoutIds = layoutIdSet.toArray(new Long[layoutIdSet.size()]);
        document.addKeyword("layoutIds", layoutIds);
    }

    protected void populateLocale(Document document, Map<String, Serializable> settingsMap) {
        Locale locale = (Locale)settingsMap.get("locale");
        document.addText("setting_locale", locale.toString());
    }

    protected void populateParameterMap(Document document, Map<String, Serializable> settingsMap) {
        if (!settingsMap.containsKey("parameterMap")) {
            return;
        }
        Map parameterMap = (Map)((Object)settingsMap.get("parameterMap"));
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] parameterValues = (String[])ArrayUtil.clone((Object[])((Object[])entry.getValue()));
            for (int i = 0; i < parameterValues.length; ++i) {
                String parameterValue = parameterValues[i];
                if (parameterValue.equals("true")) {
                    parameterValues[i] = "on";
                    continue;
                }
                if (!parameterValue.equals("false")) continue;
                parameterValues[i] = "off";
            }
            document.addKeyword(_PREFIX_PARAMETER + (String)entry.getKey(), parameterValues);
        }
    }

    protected void populateSiteInformation(Document document, Map<String, Serializable> settingsMap) {
        document.addKeyword("setting_privateLayout", MapUtil.getBoolean(settingsMap, (String)"privateLayout"));
        document.addKeyword("setting_sourceGroupId", MapUtil.getLong(settingsMap, (String)"sourceGroupId"));
        document.addKeyword("setting_targetGroupId", MapUtil.getLong(settingsMap, (String)"targetGroupId"));
    }

    protected void populateTimeZone(Document document, Map<String, Serializable> settingsMap) {
        TimeZone timeZone = (TimeZone)settingsMap.get("timeZone");
        if (timeZone != null) {
            document.addKeyword("setting_timeZone", timeZone.getDisplayName());
        }
    }

    protected void reindexExportImportConfigurations(long companyId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = ExportImportConfigurationLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)object;
                Document document = ExportImportConfigurationIndexer.this.getDocument(exportImportConfiguration);
                actionableDynamicQuery.addDocument(document);
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

