/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.lar;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.layoutsadmin.lar.StagedThemeImpl;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutStagedModelDataHandler
extends BaseStagedModelDataHandler<Layout> {
    public static final String[] CLASS_NAMES = new String[]{Layout.class.getName()};
    private static final String _SAME_GROUP_FRIENDLY_URL = "/[$SAME_GROUP_FRIENDLY_URL$]";
    private static Log _log = LogFactoryUtil.getLog(LayoutStagedModelDataHandler.class);
    private LayoutLocalServiceHelper _layoutLocalServiceHelper = (LayoutLocalServiceHelper)PortalBeanLocatorUtil.locate((String)LayoutLocalServiceHelper.class.getName());

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        boolean privateLayout = extraDataJSONObject.getBoolean("privateLayout");
        Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)uuid, (long)groupId, (boolean)privateLayout);
        if (layout != null) {
            LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)true, (ServiceContext)new ServiceContext());
        }
    }

    public Layout fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List layouts = LayoutLocalServiceUtil.getLayoutsByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)layouts)) {
            return null;
        }
        return (Layout)layouts.get(0);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Layout layout) {
        return layout.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, Layout layout) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("private-layout", String.valueOf(layout.isPrivateLayout()));
        referenceAttributes.put("layout-id", String.valueOf(layout.getLayoutId()));
        return referenceAttributes;
    }

    public void importMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        boolean privateLayout = GetterUtil.getBoolean((String)referenceElement.attributeValue("private-layout"));
        Layout existingLayout = null;
        existingLayout = this.fetchMissingReference(uuid, liveGroupId, privateLayout);
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        long layoutId = GetterUtil.getLong((String)referenceElement.attributeValue("layout-id"));
        layouts.put(layoutId, existingLayout);
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        layoutPlids.put(plid, existingLayout.getPlid());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        boolean privateLayout = GetterUtil.getBoolean((String)referenceElement.attributeValue("private-layout"));
        Layout existingLayout = this.fetchMissingReference(uuid, liveGroupId, privateLayout);
        return existingLayout != null;
    }

    protected String[] appendPortletIds(String[] portletIds, String[] newPortletIds, String portletsMergeMode) {
        for (String portletId : newPortletIds) {
            if (ArrayUtil.contains((Object[])portletIds, (Object)portletId)) continue;
            portletIds = portletsMergeMode.equals("ADD_TO_BOTTOM") ? (String[])ArrayUtil.append((Object[])portletIds, (Object)portletId) : (String[])ArrayUtil.append((Object[])new String[]{portletId}, (Object[])portletIds);
        }
        return portletIds;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Layout layout) throws Exception {
        Layout parentLayout;
        Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
        this.populateElementLayoutMetadata(layoutElement, layout);
        layoutElement.addAttribute("action", "add");
        portletDataContext.setPlid(layout.getPlid());
        long parentLayoutId = layout.getParentLayoutId();
        if (parentLayoutId != 0L && (parentLayout = LayoutLocalServiceUtil.fetchLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId)) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)parentLayout, (String)"parent");
            layoutElement.addAttribute("parent-layout-uuid", parentLayout.getUuid());
        }
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)layoutFriendlyURL, (String)"dependency");
        }
        if (layout.isIconImage()) {
            this.exportLayoutIconImage(portletDataContext, layout, layoutElement);
        }
        if (layout.isTypeArticle()) {
            this.exportJournalArticle(portletDataContext, layout);
        } else if (layout.isTypeLinkToLayout()) {
            this.exportLinkedLayout(portletDataContext, layout, layoutElement);
        }
        this.fixExportTypeSettings(layout);
        this.exportTheme(portletDataContext, layout);
        portletDataContext.addClassedModel(layoutElement, ExportImportPathUtil.getModelPath((StagedModel)layout), (ClassedModel)layout);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Layout layout) throws Exception {
        long layoutId;
        long groupId = portletDataContext.getGroupId();
        long userId = portletDataContext.getUserId(layout.getUserUuid());
        Element layoutElement = portletDataContext.getImportDataStagedModelElement((StagedModel)layout);
        String layoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-uuid"));
        long oldLayoutId = layoutId = (long)GetterUtil.getInteger((String)layoutElement.attributeValue("layout-id"));
        boolean privateLayout = portletDataContext.isPrivateLayout();
        String action = layoutElement.attributeValue("action");
        if (action.equals("delete")) {
            Layout deletingLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)privateLayout);
            LayoutLocalServiceUtil.deleteLayout((Layout)deletingLayout, (boolean)false, (ServiceContext)ServiceContextThreadLocal.getServiceContext());
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        Layout existingLayout = null;
        Layout importedLayout = null;
        String friendlyURL = layout.getFriendlyURL();
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (layoutsImportMode.equals("ADD_AS_NEW")) {
            layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            friendlyURL = "/" + layoutId;
        } else if (layoutsImportMode.equals("MERGE_BY_LAYOUT_NAME")) {
            Locale locale = LocaleUtil.getSiteDefault();
            String localizedName = layout.getName(locale);
            List previousLayouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout);
            for (Layout curLayout : previousLayouts) {
                if (!localizedName.equals(curLayout.getName(locale)) && !friendlyURL.equals(curLayout.getFriendlyURL())) continue;
                existingLayout = curLayout;
                break;
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        } else if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            existingLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getUuid(), (long)groupId, (boolean)privateLayout);
            if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)existingLayout)) {
                layouts.put(oldLayoutId, existingLayout);
                return;
            }
            LayoutFriendlyURL layoutFriendlyURL = LayoutFriendlyURLLocalServiceUtil.fetchFirstLayoutFriendlyURL((long)groupId, (boolean)privateLayout, (String)friendlyURL);
            if (layoutFriendlyURL != null && existingLayout == null) {
                Layout mergeFailFriendlyURLLayout = LayoutLocalServiceUtil.getLayout((long)layoutFriendlyURL.getPlid());
                SitesUtil.addMergeFailFriendlyURLLayout((Layout)mergeFailFriendlyURLLayout);
                return;
            }
        } else {
            existingLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getUuid(), (long)groupId, (boolean)privateLayout);
            if (existingLayout == null) {
                existingLayout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL((long)groupId, (boolean)privateLayout, (String)friendlyURL);
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        }
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("Layout with {groupId=");
            sb.append(groupId);
            sb.append(",privateLayout=");
            sb.append(privateLayout);
            sb.append(",layoutId=");
            sb.append(layoutId);
            if (existingLayout == null) {
                sb.append("} does not exist");
                _log.debug((Object)sb.toString());
            } else {
                sb.append("} exists");
                _log.debug((Object)sb.toString());
            }
        }
        if (existingLayout == null) {
            long plid = CounterLocalServiceUtil.increment();
            importedLayout = LayoutLocalServiceUtil.createLayout((long)plid);
            if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                importedLayout.setSourcePrototypeLayoutUuid(layout.getUuid());
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            } else {
                importedLayout.setCreateDate(layout.getCreateDate());
                importedLayout.setModifiedDate(layout.getModifiedDate());
                importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
                importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
                importedLayout.setSourcePrototypeLayoutUuid(layout.getSourcePrototypeLayoutUuid());
            }
            importedLayout.setUuid(layout.getUuid());
            importedLayout.setGroupId(groupId);
            importedLayout.setUserId(userId);
            importedLayout.setPrivateLayout(privateLayout);
            importedLayout.setLayoutId(layoutId);
            this.initNewLayoutPermissions(portletDataContext.getCompanyId(), groupId, userId, layout, importedLayout, privateLayout);
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            importedLayout.setLayoutSet(layoutSet);
        } else {
            importedLayout = existingLayout;
        }
        portletDataContext.setPlid(importedLayout.getPlid());
        portletDataContext.setOldPlid(layout.getPlid());
        long parentLayoutId = layout.getParentLayoutId();
        String parentLayoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("parent-layout-uuid"));
        Element parentLayoutElement = portletDataContext.getReferenceDataElement((StagedModel)layout, Layout.class, layout.getGroupId(), parentLayoutUuid);
        if (parentLayoutId != 0L && parentLayoutElement != null) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)parentLayoutElement);
            Layout importedParentLayout = (Layout)layouts.get(parentLayoutId);
            parentLayoutId = importedParentLayout.getLayoutId();
        }
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(4);
            sb.append("Importing layout with layout id ");
            sb.append(layoutId);
            sb.append(" and parent layout id ");
            sb.append(parentLayoutId);
            _log.debug((Object)sb.toString());
        }
        importedLayout.setCompanyId(portletDataContext.getCompanyId());
        if (layout.getLayoutPrototypeUuid() != null) {
            importedLayout.setModifiedDate(new Date());
        }
        importedLayout.setParentLayoutId(parentLayoutId);
        importedLayout.setName(layout.getName());
        importedLayout.setTitle(layout.getTitle());
        importedLayout.setDescription(layout.getDescription());
        importedLayout.setKeywords(layout.getKeywords());
        importedLayout.setRobots(layout.getRobots());
        importedLayout.setType(layout.getType());
        String portletsMergeMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"PORTLETS_MERGE_MODE", (String)"REPLACE");
        if (layout.isTypeArticle()) {
            this.importJournalArticle(portletDataContext, layout);
            this.updateTypeSettings(importedLayout, layout);
        } else if (layout.isTypePortlet() && Validator.isNotNull((String)layout.getTypeSettings()) && !portletsMergeMode.equals("REPLACE")) {
            this.mergePortlets(importedLayout, layout.getTypeSettings(), portletsMergeMode);
        } else if (layout.isTypeLinkToLayout()) {
            this.importLinkedLayout(portletDataContext, layout, importedLayout, layoutElement, layouts);
        } else {
            this.updateTypeSettings(importedLayout, layout);
        }
        importedLayout.setHidden(layout.isHidden());
        importedLayout.setFriendlyURL(this.getUniqueFriendlyURL(portletDataContext, importedLayout, friendlyURL));
        if (layout.getIconImageId() > 0L) {
            this.importLayoutIconImage(portletDataContext, importedLayout, layoutElement);
        } else if (importedLayout.getIconImageId() > 0L) {
            ImageLocalServiceUtil.deleteImage((long)importedLayout.getIconImageId());
        }
        if (existingLayout == null) {
            int priority = this._layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, null, -1);
            importedLayout.setPriority(priority);
        }
        importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
        importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layout);
        importedLayout.setExpandoBridgeAttributes(serviceContext);
        StagingUtil.updateLastImportSettings((Element)layoutElement, (Layout)importedLayout, (PortletDataContext)portletDataContext);
        this.fixImportTypeSettings(importedLayout);
        this.importTheme(portletDataContext, layout, importedLayout);
        LayoutLocalServiceUtil.updateLayout((Layout)importedLayout);
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        layoutPlids.put(layout.getPlid(), importedLayout.getPlid());
        layouts.put(oldLayoutId, importedLayout);
        this.importAssets(portletDataContext, layout, importedLayout);
        this.importLayoutFriendlyURLs(portletDataContext, layout);
        portletDataContext.importClassedModel((ClassedModel)layout, (ClassedModel)importedLayout);
    }

    protected void exportJournalArticle(PortletDataContext portletDataContext, Layout layout) throws Exception {
        JournalArticle article;
        block4: {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id", "");
            long articleGroupId = layout.getGroupId();
            if (Validator.isNull((String)articleId) && _log.isWarnEnabled()) {
                _log.warn((Object)("No article id found in typeSettings of layout " + layout.getPlid()));
            }
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)0);
            }
            catch (NoSuchArticleException nsae) {
                if (!_log.isWarnEnabled()) break block4;
                StringBundler sb = new StringBundler(4);
                sb.append("No approved article found with group id ");
                sb.append(articleGroupId);
                sb.append(" and layout id ");
                sb.append(articleId);
                _log.warn((Object)sb.toString());
            }
        }
        if (article == null) {
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)article, (String)"embedded");
    }

    protected void exportLayoutIconImage(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        Image image = ImageLocalServiceUtil.getImage((long)layout.getIconImageId());
        if (image != null) {
            String iconPath = ExportImportPathUtil.getModelPath((long)portletDataContext.getScopeGroupId(), (String)Image.class.getName(), (long)image.getImageId());
            Element iconImagePathElement = layoutElement.addElement("icon-image-path");
            iconImagePathElement.addText(iconPath);
            portletDataContext.addZipEntry(iconPath, image.getTextObj());
        }
    }

    protected void exportLinkedLayout(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
        if (linkToLayoutId > 0L) {
            try {
                Layout linkedToLayout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)linkToLayoutId);
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)linkedToLayout, (String)"strong");
                layoutElement.addAttribute("linked-to-layout-uuid", linkedToLayout.getUuid());
            }
            catch (NoSuchLayoutException nsle) {
                // empty catch block
            }
        }
    }

    protected void exportTheme(PortletDataContext portletDataContext, Layout layout) throws Exception {
        boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export theme settings " + exportThemeSettings));
        }
        if (exportThemeSettings && !portletDataContext.isPerformDirectBinaryImport() && !layout.isInheritLookAndFeel()) {
            StagedThemeImpl stagedTheme = new StagedThemeImpl(layout.getTheme());
            Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
            portletDataContext.addReferenceElement((ClassedModel)layout, layoutElement, (ClassedModel)stagedTheme, "dependency", true);
        }
    }

    protected Object[] extractFriendlyURLInfo(Layout layout) {
        if (!layout.isTypeURL()) {
            return null;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return null;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return null;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return null;
        }
        return new Object[]{url.substring(x, y), url, x, y};
    }

    protected Layout fetchMissingReference(String uuid, long groupId, boolean privateLayout) {
        Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)uuid, (long)groupId, (boolean)privateLayout);
        if (layout != null) {
            return layout;
        }
        try {
            Group originalGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            for (Group group = originalGroup.getParentGroup(); group != null && (layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)uuid, (long)group.getGroupId(), (boolean)privateLayout)) == null; group = group.getParentGroup()) {
            }
            if (layout == null) {
                layout = this.fetchStagedModelByUuidAndCompanyId(uuid, originalGroup.getCompanyId());
            }
            return layout;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch missing reference layout from group " + groupId));
            }
            return null;
        }
    }

    protected void fixExportTypeSettings(Layout layout) throws Exception {
        Object[] friendlyURLInfo = this.extractFriendlyURLInfo(layout);
        if (friendlyURLInfo == null) {
            return;
        }
        String friendlyURL = (String)friendlyURLInfo[0];
        Group group = layout.getGroup();
        String groupFriendlyURL = group.getFriendlyURL();
        if (!friendlyURL.equals(groupFriendlyURL)) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = (String)friendlyURLInfo[1];
        int x = (Integer)friendlyURLInfo[2];
        int y = (Integer)friendlyURLInfo[3];
        typeSettings.setProperty("url", url.substring(0, x) + _SAME_GROUP_FRIENDLY_URL + url.substring(y));
    }

    protected void fixImportTypeSettings(Layout layout) throws Exception {
        Object[] friendlyURLInfo = this.extractFriendlyURLInfo(layout);
        if (friendlyURLInfo == null) {
            return;
        }
        String friendlyURL = (String)friendlyURLInfo[0];
        if (!friendlyURL.equals(_SAME_GROUP_FRIENDLY_URL)) {
            return;
        }
        Group group = layout.getGroup();
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = (String)friendlyURLInfo[1];
        int x = (Integer)friendlyURLInfo[2];
        int y = (Integer)friendlyURLInfo[3];
        typeSettings.setProperty("url", url.substring(0, x) + group.getFriendlyURL() + url.substring(y));
    }

    protected String getUniqueFriendlyURL(PortletDataContext portletDataContext, Layout existingLayout, String friendlyURL) {
        Layout duplicateFriendlyURLLayout;
        int i = 1;
        while ((duplicateFriendlyURLLayout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL((long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout(), (String)friendlyURL)) != null && duplicateFriendlyURLLayout.getPlid() != existingLayout.getPlid()) {
            friendlyURL = friendlyURL + i;
            ++i;
        }
        return friendlyURL;
    }

    protected void importAssets(PortletDataContext portletDataContext, Layout layout, Layout importedLayout) throws Exception {
        long userId = portletDataContext.getUserId(layout.getUserUuid());
        long[] assetCategoryIds = portletDataContext.getAssetCategoryIds(Layout.class, layout.getPlid());
        String[] assetTagNames = portletDataContext.getAssetTagNames(Layout.class, layout.getPlid());
        LayoutLocalServiceUtil.updateAsset((long)userId, (Layout)importedLayout, (long[])assetCategoryIds, (String[])assetTagNames);
    }

    protected void importJournalArticle(PortletDataContext portletDataContext, Layout layout) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        String articleId = typeSettingsProperties.getProperty("article-id", "");
        if (Validator.isNull((String)articleId)) {
            return;
        }
        List referenceDataElements = portletDataContext.getReferenceDataElements((StagedModel)layout, JournalArticle.class);
        if (!referenceDataElements.isEmpty()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)((Element)referenceDataElements.get(0)));
        }
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
        typeSettingsProperties.setProperty("article-id", articleId);
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)"", (String)articleId, (boolean)true);
    }

    protected void importLayoutFriendlyURLs(PortletDataContext portletDataContext, Layout layout) throws Exception {
        List layoutFriendlyURLElements = portletDataContext.getReferenceDataElements((StagedModel)layout, LayoutFriendlyURL.class);
        for (Element layoutFriendlyURLElement : layoutFriendlyURLElements) {
            String layoutFriendlyURLPath = layoutFriendlyURLElement.attributeValue("path");
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)portletDataContext.getZipEntryAsObject(layoutFriendlyURLPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutFriendlyURL);
        }
    }

    protected void importLayoutIconImage(PortletDataContext portletDataContext, Layout importedLayout, Element layoutElement) throws Exception {
        String iconImagePath = layoutElement.elementText("icon-image-path");
        byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(iconImagePath);
        if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
            if (importedLayout.getIconImageId() == 0L) {
                long iconImageId = CounterLocalServiceUtil.increment();
                importedLayout.setIconImageId(iconImageId);
            }
            ImageLocalServiceUtil.updateImage((long)importedLayout.getIconImageId(), (byte[])iconBytes);
        }
    }

    protected void importLinkedLayout(PortletDataContext portletDataContext, Layout layout, Layout importedLayout, Element layoutElement, Map<Long, Layout> layouts) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
        String linkedToLayoutUuid = layoutElement.attributeValue("linked-to-layout-uuid");
        if (Validator.isNull((String)linkedToLayoutUuid)) {
            return;
        }
        if (linkToLayoutId <= 0L) {
            this.updateTypeSettings(importedLayout, layout);
            return;
        }
        Element linkedToLayoutElement = portletDataContext.getReferenceDataElement((StagedModel)layout, Layout.class, layout.getGroupId(), linkedToLayoutUuid);
        if (linkedToLayoutElement != null) {
            String linkedToLayoutPath = linkedToLayoutElement.attributeValue("path");
            Layout linkedToLayout = (Layout)portletDataContext.getZipEntryAsObject(linkedToLayoutPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)linkedToLayout);
            Layout importedLinkedLayout = layouts.get(linkToLayoutId);
            typeSettingsProperties.setProperty("privateLayout", String.valueOf(importedLinkedLayout.isPrivateLayout()));
            typeSettingsProperties.setProperty("linkToLayoutId", String.valueOf(importedLinkedLayout.getLayoutId()));
        } else if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Unable to link layout with friendly URL ");
            sb.append(layout.getFriendlyURL());
            sb.append(" and layout id ");
            sb.append(layout.getLayoutId());
            sb.append(" to layout with layout id ");
            sb.append(linkToLayoutId);
            _log.warn((Object)sb.toString());
        }
        this.updateTypeSettings(importedLayout, layout);
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, Layout layout) {
    }

    protected void importTheme(PortletDataContext portletDataContext, Layout layout, Layout importedLayout) throws Exception {
        boolean importThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import theme settings " + importThemeSettings));
        }
        if (importThemeSettings) {
            importedLayout.setColorSchemeId(layout.getColorSchemeId());
            importedLayout.setCss(layout.getCss());
            importedLayout.setThemeId(layout.getThemeId());
            importedLayout.setWapColorSchemeId(layout.getWapColorSchemeId());
            importedLayout.setWapThemeId(layout.getWapThemeId());
        } else {
            importedLayout.setColorSchemeId("");
            importedLayout.setCss("");
            importedLayout.setThemeId("");
            importedLayout.setWapColorSchemeId("");
            importedLayout.setWapThemeId("");
        }
    }

    protected void initNewLayoutPermissions(long companyId, long groupId, long userId, Layout layout, Layout importedLayout, boolean privateLayout) throws Exception {
        boolean addGroupPermissions = true;
        Group group = importedLayout.getGroup();
        if (privateLayout && group.isUser()) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || layout.isTypeControlPanel()) {
            addGuestPermissions = true;
        }
        ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)userId, (String)Layout.class.getName(), (long)importedLayout.getPlid(), (boolean)false, (boolean)addGroupPermissions, (boolean)addGuestPermissions);
    }

    protected void mergePortlets(Layout layout, String newTypeSettings, String portletsMergeMode) {
        try {
            UnicodeProperties previousTypeSettingsProperties = layout.getTypeSettingsProperties();
            LayoutTypePortlet previousLayoutType = (LayoutTypePortlet)layout.getLayoutType();
            LayoutTemplate previousLayoutTemplate = previousLayoutType.getLayoutTemplate();
            List previousColumns = previousLayoutTemplate.getColumns();
            UnicodeProperties newTypeSettingsProperties = new UnicodeProperties(true);
            newTypeSettingsProperties.load(newTypeSettings);
            String layoutTemplateId = newTypeSettingsProperties.getProperty("layout-template-id");
            previousTypeSettingsProperties.setProperty("layout-template-id", layoutTemplateId);
            String nestedColumnIds = newTypeSettingsProperties.getProperty("nested-column-ids");
            if (Validator.isNotNull((String)nestedColumnIds)) {
                String[] nestedColumnIdsArray;
                previousTypeSettingsProperties.setProperty("nested-column-ids", nestedColumnIds);
                for (String nestedColumnId : nestedColumnIdsArray = StringUtil.split((String)nestedColumnIds)) {
                    String nestedColumnValue = newTypeSettingsProperties.getProperty(nestedColumnId);
                    previousTypeSettingsProperties.setProperty(nestedColumnId, nestedColumnValue);
                }
            }
            LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)false, null);
            Object[] newPortletIds = new String[]{};
            for (String columnId : newLayoutTemplate.getColumns()) {
                String columnValue = newTypeSettingsProperties.getProperty(columnId);
                Object[] portletIds = StringUtil.split((String)columnValue);
                if (!previousColumns.contains(columnId)) {
                    newPortletIds = (String[])ArrayUtil.append((Object[])newPortletIds, (Object[])portletIds);
                    continue;
                }
                String[] previousPortletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
                portletIds = this.appendPortletIds(previousPortletIds, (String[])portletIds, portletsMergeMode);
                previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            }
            String columnId = (String)previousColumns.get(0);
            Object[] portletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
            this.appendPortletIds((String[])portletIds, (String[])newPortletIds, portletsMergeMode);
            previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            layout.setTypeSettings(previousTypeSettingsProperties.toString());
        }
        catch (IOException ioe) {
            layout.setTypeSettings(newTypeSettings);
        }
    }

    protected void populateElementLayoutMetadata(Element layoutElement, Layout layout) throws Exception {
        LayoutRevision layoutRevision;
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler != null && (layoutRevision = layoutStagingHandler.getLayoutRevision()) != null) {
            layoutElement.addAttribute("layout-revision-id", String.valueOf(layoutRevision.getLayoutRevisionId()));
            layoutElement.addAttribute("layout-branch-id", String.valueOf(layoutRevision.getLayoutBranchId()));
            LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
            layoutElement.addAttribute("layout-branch-name", String.valueOf(layoutBranch.getName()));
        }
        layoutElement.addAttribute("layout-uuid", layout.getUuid());
        layoutElement.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        layoutElement.addAttribute("layout-priority", String.valueOf(layout.getPriority()));
        String layoutPrototypeUuid = layout.getLayoutPrototypeUuid();
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)layout.getCompanyId());
            layoutElement.addAttribute("layout-prototype-uuid", layoutPrototypeUuid);
            layoutElement.addAttribute("layout-prototype-name", layoutPrototype.getName(LocaleUtil.getDefault()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTypeSettings(Layout importedLayout, Layout layout) throws PortalException {
        long groupId = layout.getGroupId();
        try {
            LayoutTypePortlet importedLayoutType = (LayoutTypePortlet)importedLayout.getLayoutType();
            List importedPortletIds = importedLayoutType.getPortletIds();
            layout.setGroupId(importedLayout.getGroupId());
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            importedPortletIds.removeAll(layoutTypePortlet.getPortletIds());
            if (!importedPortletIds.isEmpty()) {
                PortletLocalServiceUtil.deletePortlets((long)importedLayout.getCompanyId(), (String[])importedPortletIds.toArray(new String[importedPortletIds.size()]), (long)importedLayout.getPlid());
            }
            importedLayout.setTypeSettingsProperties(layoutTypePortlet.getTypeSettingsProperties());
        }
        finally {
            layout.setGroupId(groupId);
        }
    }
}

