/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutDescription;
import com.liferay.portal.util.LayoutListUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.layoutsadmin.context.GroupDisplayContextHelper;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutsAdminDisplayContext {
    private String _backURL;
    private final GroupDisplayContextHelper _groupDisplayContextHelper;
    private List<LayoutDescription> _layoutDescriptions;
    private Long _layoutId;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Organization _organization;
    private String _pagesName;
    private final boolean _privateLayout;
    private String _redirect;
    private final HttpServletRequest _request;
    private String _rootNodeName;
    private Layout _selLayout;
    private LayoutSet _selLayoutSet;
    private Long _selPlid;
    private User _selUser;
    private final String _tabs1;
    private String _tabs1Names;
    private UserGroup _userGroup;

    public LayoutsAdminDisplayContext(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) {
        Group selGroup;
        Group liveGroup;
        Layout selLayout;
        this._request = request;
        this._liferayPortletResponse = liferayPortletResponse;
        this._groupDisplayContextHelper = new GroupDisplayContextHelper(request);
        boolean privateLayout = false;
        String tabs1 = ParamUtil.getString((HttpServletRequest)request, (String)"tabs1", (String)"public-pages");
        if (tabs1.equals("my-dashboard") || tabs1.equals("private-pages")) {
            privateLayout = true;
        }
        if ((selLayout = this.getSelLayout()) != null) {
            privateLayout = selLayout.isPrivateLayout();
        }
        if ((liveGroup = this.getLiveGroup()).isUser() && !this.isPublicLayoutsModifiable() && this.isPrivateLayoutsModifiable() && !privateLayout) {
            privateLayout = true;
            tabs1 = "my-dashboard";
        }
        if ((selGroup = this.getSelGroup()).isLayoutSetPrototype()) {
            privateLayout = true;
        }
        this._privateLayout = privateLayout;
        this._tabs1 = tabs1;
        String portletName = this.getPortletName();
        if (portletName.equals("88") || portletName.equals("2")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletDisplay.setURLBack(this.getBackURL());
        }
        this._request.setAttribute("LAYOUT_DESCRIPTIONS", this.getLayoutDescriptions());
    }

    public String getBackURL() {
        if (this._backURL != null) {
            return this._backURL;
        }
        this._backURL = ParamUtil.getString((HttpServletRequest)this._request, (String)"backURL", (String)this.getRedirect());
        return this._backURL;
    }

    public PortletURL getEditLayoutURL() {
        String closeRedirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"closeRedirect");
        PortletURL editLayoutURL = this._liferayPortletResponse.createRenderURL();
        editLayoutURL.setParameter("struts_action", "/layouts_admin/edit_layouts");
        editLayoutURL.setParameter("tabs1", this.getTabs1());
        editLayoutURL.setParameter("redirect", this.getRedirect());
        editLayoutURL.setParameter("closeRedirect", closeRedirect);
        String portletName = this.getPortletName();
        if (portletName.equals("88") || portletName.equals("2") || portletName.equals("125")) {
            editLayoutURL.setParameter("backURL", this.getBackURL());
        }
        editLayoutURL.setParameter("groupId", String.valueOf(this.getLiveGroupId()));
        editLayoutURL.setParameter("viewLayout", Boolean.TRUE.toString());
        return editLayoutURL;
    }

    public Group getGroup() {
        return this._groupDisplayContextHelper.getGroup();
    }

    public Long getGroupId() {
        return this._groupDisplayContextHelper.getGroupId();
    }

    public UnicodeProperties getGroupTypeSettings() {
        return this._groupDisplayContextHelper.getGroupTypeSettings();
    }

    public List<LayoutDescription> getLayoutDescriptions() {
        if (this._layoutDescriptions != null) {
            return this._layoutDescriptions;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._layoutDescriptions = LayoutListUtil.getLayoutDescriptions(this.getGroupId(), this.isPrivateLayout(), this.getRootNodeName(), themeDisplay.getLocale());
        return this._layoutDescriptions;
    }

    public Long getLayoutId() {
        if (this._layoutId != null) {
            return this._layoutId;
        }
        this._layoutId = 0L;
        Layout selLayout = this.getSelLayout();
        if (selLayout != null) {
            this._layoutId = selLayout.getLayoutId();
        }
        return this._layoutId;
    }

    public Group getLiveGroup() {
        return this._groupDisplayContextHelper.getLiveGroup();
    }

    public Long getLiveGroupId() {
        return this._groupDisplayContextHelper.getLiveGroupId();
    }

    public Organization getOrganization() {
        if (this._organization != null) {
            return this._organization;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isOrganization()) {
            this._organization = OrganizationLocalServiceUtil.fetchOrganization((long)liveGroup.getOrganizationId());
        }
        return this._organization;
    }

    public String getPagesName() {
        if (this._pagesName != null) {
            return this._pagesName;
        }
        Group liveGroup = this.getLiveGroup();
        this._pagesName = liveGroup.isLayoutPrototype() || liveGroup.isLayoutSetPrototype() || liveGroup.isUserGroup() ? "pages" : (this.isPrivateLayout() ? (liveGroup.isUser() ? "my-dashboard" : "private-pages") : (liveGroup.isUser() ? "my-profile" : "public-pages"));
        return this._pagesName;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        return this._redirect;
    }

    public PortletURL getRedirectURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/layouts_admin/edit_layouts");
        portletURL.setParameter("tabs1", this.getTabs1());
        portletURL.setParameter("redirect", this.getRedirect());
        String portletName = this.getPortletName();
        if (portletName.equals("88") || portletName.equals("2") || portletName.equals("125")) {
            portletURL.setParameter("backURL", this.getBackURL());
        }
        portletURL.setParameter("groupId", String.valueOf(this.getLiveGroupId()));
        return portletURL;
    }

    public String getRootNodeName() {
        if (this._rootNodeName != null) {
            return this._rootNodeName;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group liveGroup = this.getLiveGroup();
        this._rootNodeName = liveGroup.getLayoutRootNodeName(this.isPrivateLayout(), themeDisplay.getLocale());
        return this._rootNodeName;
    }

    public Group getSelGroup() {
        return this._groupDisplayContextHelper.getSelGroup();
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public LayoutSet getSelLayoutSet() throws PortalException {
        if (this._selLayoutSet != null) {
            return this._selLayoutSet;
        }
        this._selLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
        return this._selLayoutSet;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((HttpServletRequest)this._request, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public User getSelUser() {
        if (this._selUser != null) {
            return this._selUser;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isUser()) {
            this._selUser = UserLocalServiceUtil.fetchUser((long)liveGroup.getClassPK());
        }
        return this._selUser;
    }

    public Group getStagingGroup() {
        return this._groupDisplayContextHelper.getStagingGroup();
    }

    public Long getStagingGroupId() {
        return this._groupDisplayContextHelper.getStagingGroupId();
    }

    public String getTabs1() {
        return this._tabs1;
    }

    public String getTabs1Names() {
        if (this._tabs1Names != null) {
            return this._tabs1Names;
        }
        this._tabs1Names = "public-pages,private-pages";
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isUser()) {
            if (this.isPrivateLayoutsModifiable() && this.isPublicLayoutsModifiable()) {
                this._tabs1Names = "my-profile,my-dashboard";
            } else if (this.isPrivateLayoutsModifiable()) {
                this._tabs1Names = "my-dashboard";
            } else if (this.isPublicLayoutsModifiable()) {
                this._tabs1Names = "my-profile";
            }
        }
        return this._tabs1Names;
    }

    public UserGroup getUserGroup() {
        if (this._userGroup != null) {
            return this._userGroup;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup.isUserGroup()) {
            this._userGroup = UserGroupLocalServiceUtil.fetchUserGroup((long)liveGroup.getClassPK());
        }
        return this._userGroup;
    }

    public boolean isPrivateLayout() {
        return this._privateLayout;
    }

    protected String getPortletName() {
        PortletConfig portletConfig = (PortletConfig)this._request.getAttribute("javax.portlet.config");
        if (portletConfig == null) {
            return "";
        }
        return portletConfig.getPortletName();
    }

    protected boolean hasPowerUserRole() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            User selUser = this.getSelUser();
            return RoleLocalServiceUtil.hasUserRole((long)selUser.getUserId(), (long)themeDisplay.getCompanyId(), (String)"Power User", (boolean)true);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isPrivateLayoutsModifiable() {
        return (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED || this.hasPowerUserRole()) && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED;
    }

    protected boolean isPublicLayoutsModifiable() {
        return (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED || this.hasPowerUserRole()) && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED;
    }
}

