/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.context;

import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import javax.servlet.http.HttpServletRequest;

public class GroupDisplayContextHelper {
    private Group _group;
    private Long _groupId;
    private UnicodeProperties _groupTypeSettings;
    private Group _liveGroup;
    private Long _liveGroupId;
    private HttpServletRequest _request;
    private Group _selGroup;
    private Group _stagingGroup;
    private Long _stagingGroupId;

    public GroupDisplayContextHelper(HttpServletRequest request) {
        this._request = request;
    }

    public Group getGroup() {
        if (this._group != null) {
            return this._group;
        }
        this._group = this.getStagingGroup() != null ? this.getStagingGroup() : this.getLiveGroup();
        return this._group;
    }

    public Long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        Group group = this.getGroup();
        if (group != null) {
            this._groupId = group.getGroupId();
        }
        return this._groupId;
    }

    public UnicodeProperties getGroupTypeSettings() {
        if (this._groupTypeSettings != null) {
            return this._groupTypeSettings;
        }
        Group group = this.getGroup();
        this._groupTypeSettings = group != null ? group.getTypeSettingsProperties() : new UnicodeProperties();
        return this._groupTypeSettings;
    }

    public Group getLiveGroup() {
        if (this._liveGroup != null) {
            return this._liveGroup;
        }
        Group group = this.getSelGroup();
        if (group == null) {
            return null;
        }
        this._liveGroup = StagingUtil.getLiveGroup((long)group.getGroupId());
        return this._liveGroup;
    }

    public Long getLiveGroupId() {
        if (this._liveGroupId != null) {
            return this._liveGroupId;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup != null) {
            this._liveGroupId = liveGroup.getGroupId();
        }
        return this._liveGroupId;
    }

    public Group getSelGroup() {
        if (this._selGroup != null) {
            return this._selGroup;
        }
        long groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        this._selGroup = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (this._selGroup == null) {
            this._selGroup = (Group)this._request.getAttribute("GROUP");
        }
        if (this._selGroup == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._selGroup = themeDisplay.getScopeGroup();
        }
        return this._selGroup;
    }

    public Group getStagingGroup() {
        if (this._stagingGroup != null) {
            return this._stagingGroup;
        }
        Group group = this.getSelGroup();
        if (group == null) {
            return null;
        }
        this._stagingGroup = StagingUtil.getStagingGroup((long)group.getGroupId());
        return this._stagingGroup;
    }

    public Long getStagingGroupId() {
        if (this._stagingGroupId != null) {
            return this._stagingGroupId;
        }
        Group stagingGroup = this.getStagingGroup();
        if (stagingGroup != null) {
            this._stagingGroupId = stagingGroup.getGroupId();
        }
        return this._stagingGroupId;
    }
}

