/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARFileSizeException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportLayoutsAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ImportLayoutsAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                this.validateFile(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
            } else if (cmd.equals("import")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.importData(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.handleUploadException(portletConfig, actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME, e);
            }
            if (e instanceof LARFileException || e instanceof LARFileSizeException || e instanceof LARTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof LayoutPrototypeException || e instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.layouts_admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.import_layouts"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = null;
        portletRequestDispatcher = cmd.equals("import") ? portletContext.getRequestDispatcher("/html/portlet/layouts_admin/import_layouts_processes.jsp") : portletContext.getRequestDispatcher("/html/portlet/layouts_admin/import_layouts_resources.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        this.checkExceededSizeLimit((HttpServletRequest)uploadPortletRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        this.deleteTempFileEntry(groupId, folderName);
        InputStream inputStream = null;
        try {
            String sourceFileName = uploadPortletRequest.getFileName("file");
            inputStream = uploadPortletRequest.getFileAsStream("file");
            String contentType = uploadPortletRequest.getContentType("file");
            LayoutServiceUtil.addTempFileEntry((long)groupId, (String)folderName, (String)sourceFileName, (InputStream)inputStream, (String)contentType);
        }
        catch (Exception e) {
            block5: {
                try {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException != null && uploadException.getCause() instanceof FileUploadBase.IOFileUploadException) break block5;
                    if (uploadException != null && uploadException.isExceededSizeLimit()) {
                        throw new FileSizeException(uploadException.getCause());
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void checkExceededSizeLimit(HttpServletRequest request) throws PortalException {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            if (uploadException.isExceededSizeLimit()) {
                throw new LARFileSizeException(uploadException.getCause());
            }
            throw new PortalException(uploadException.getCause());
        }
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
            LayoutServiceUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (String)folderName, (String)fileName);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    protected void deleteTempFileEntry(long groupId, String folderName) throws PortalException {
        String[] tempFileNames;
        for (String tempFileEntryName : tempFileNames = LayoutServiceUtil.getTempFileNames((long)groupId, (String)folderName)) {
            LayoutServiceUtil.deleteTempFileEntry((long)groupId, (String)folderName, (String)tempFileEntryName);
        }
    }

    protected void handleUploadException(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String folderName, Exception e) throws Exception {
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        response.setContentType("text/html");
        response.setStatus(200);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.deleteTempFileEntry(themeDisplay.getScopeGroupId(), folderName);
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)themeDisplay.getLocale(), (Exception)e, null);
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        ServletResponseUtil.write((HttpServletResponse)response, (String)String.valueOf(jsonObject.getInt("status")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importData(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)folderName);
        InputStream inputStream = null;
        try {
            inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
            this.importData(actionRequest, fileEntry.getTitle(), inputStream);
            this.deleteTempFileEntry(groupId, folderName);
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void importData(ActionRequest actionRequest, String fileName, InputStream inputStream) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutServiceUtil.importLayoutsInBackground((String)fileName, (long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (InputStream)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateFile(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        Map weakMissingReferences;
        InputStream inputStream;
        ThemeDisplay themeDisplay;
        block4: {
            themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)folderName);
            inputStream = null;
            try {
                inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
                MissingReferences missingReferences = this.validateFile(actionRequest, inputStream);
                weakMissingReferences = missingReferences.getWeakMissingReferences();
                if (!weakMissingReferences.isEmpty()) break block4;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
            jsonObject.put("warningMessages", StagingUtil.getWarningMessagesJSONArray((Locale)themeDisplay.getLocale(), (Map)weakMissingReferences, null));
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected MissingReferences validateFile(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        return LayoutServiceUtil.validateImportLayoutsFile((long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (InputStream)inputStream);
    }
}

