/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.LARFileNameException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.sites.action.ActionUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportLayoutsAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ExportLayoutsAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block3: {
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            if (Validator.isNull((String)cmd)) {
                return;
            }
            try {
                long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
                boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
                long[] layoutIds = this.getLayoutIds((PortletRequest)actionRequest);
                String taskName = "";
                taskName = privateLayout ? LanguageUtil.get((Locale)actionRequest.getLocale(), (String)"private-pages") : LanguageUtil.get((Locale)actionRequest.getLocale(), (String)"public-pages");
                LayoutServiceUtil.exportLayoutsAsFileInBackground((String)taskName, (long)groupId, (boolean)privateLayout, (long[])layoutIds, (Map)actionRequest.getParameterMap(), null, null);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
            catch (Exception e) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                if (e instanceof LARFileNameException) break block3;
                _log.error((Object)e, (Throwable)e);
                String pagesRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
                this.sendRedirect(actionRequest, actionResponse, pagesRedirect);
            }
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.layouts_admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.export_layouts"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/export_layouts_processes.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected long[] getLayoutIds(PortletRequest portletRequest) throws Exception {
        LinkedHashSet<Layout> layouts = new LinkedHashSet<Layout>();
        Map layoutIdMap = ExportImportHelperUtil.getLayoutIdMap((PortletRequest)portletRequest);
        for (Map.Entry entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = (Boolean)entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            if (!includeChildren) continue;
            layouts.addAll(layout.getAllChildren());
        }
        return ExportImportHelperUtil.getLayoutIds(new ArrayList(layouts));
    }
}

